/*
    ROVM  Ȯ  ۼ  ֵ ִ  
  Դϴ.
 */

#ifndef _ROVM_ENVLANG_H
#define _ROVM_ENVLANG_H

#ifndef ERRLOG_EMERG
#define	ERRLOG_EMERG		0	/* system is unusable */
#define	ERRLOG_ALERT		1	/* action must be taken immediately */
#define	ERRLOG_CRIT		2	/* critical conditions */
#define	ERRLOG_ERR		3	/* error conditions */
#define	ERRLOG_WARNING		4	/* warning conditions */
#define	ERRLOG_NOTICE		5	/* normal but significant condition */
#define	ERRLOG_INFO		6	/* informational */
#define	ERRLOG_DEBUG		7	/* debug-level messages */

#define	ERRLOG_LEVELMASK	7	/* mask off the level value */

#define ERRLOG_WITHERRNO	(ERRLOG_LEVELMASK + 1)
#define ERRLOG_MARK		__FILE__,__LINE__
#endif

/*
  ٸ   typedef  浹 ϱ ؼ Ʒ 
  #ifndef  ϰ Ǿϴ.
*/
#ifndef ROVM_ECLASS_TYPEDEF
typedef struct eclass RvClass;
#endif
#ifndef ROVM_EOBJECT_TYPEDEF
typedef struct eobject RvObject;
#endif
#ifndef ROVM_EVALUE_TYPEDEF
typedef struct rovm_stack RvValue;
#endif

#ifndef NULL_OBJECT
#define NULL_OBJECT             (RvObject *) 0
#endif
#ifndef NULL_VALUE
#define NULL_VALUE              (RvValue *) 0
#endif

typedef struct emethoddef RvMethodDef;
typedef struct efielddef RvFieldDef;

/**
   Field   üԴϴ.
 */
struct efielddef
{
  const char *name;
  const char *type;
};

/**
   Method    üԴϴ.
 */
struct emethoddef
{
  const char *name;
  const char *type;

  int (*func) (RvObject *cls, RvValue *arg, RvValue *ret);
};

/**
   ObjectRef  ڰ Ÿ   ˴ϴ.

   @param self   ObjectRef
   @param idx     index ȣ (ݵ OBJECT_MAX_USERDATA 
                 ۾ƾ մϴ.
   @param value  .
*/
extern int RvSetUserData (RvObject *, int, void *);

/**
   ObjectRef  ڰ  Ÿ  , Ѵ.

   (ܺ  Լ)

   @param self   ObjectRef
   @param idx    Ÿ index ȣ
   @return      ڰ   ȯմϴ.
*/
extern void *RvGetUserData (RvObject *, int);

/**
   FDS  ǵǾ ִ field  Ŭ CLS   field  Ѵ.

   @param cls    Class   Ŭ  
   @param fds   Field  Ǿ ִ ü .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
*/
extern int RvDefineFields (RvClass *cls, RvFieldDef *fds);

/**
   CLS  MD  о ش Method  ǵ CLS ο Ѵ.

   @param cls    Class   Ŭ  
   @param md    Method  Ǿ ִ .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
*/
extern int RvDefineMethods (RvClass *, RvMethodDef *);

/**
   ARGS  FMT  Ͽ ش  ùٸ   ִ Ȱ ϴ
   ԼԴϴ.

   @param args  RvValue üԴϴ.  ̰ Stack Slot   ͸
                 ˴ϴ.
   @param fmt   ؼ Դϴ.
   @return        0 , ׷   -1  ȯѴ.
*/
extern int RvParseArg (RvObject *, RvValue *, const char *, ...);

/**
   ڿ ArrayRef  ȯϿ ȯմϴ.  (NewRvArray  Ҵ
   GC ޸𸮴 ڵ delayed slot  ϵǾ ֽϴ.)

   @param self  SELF ObjectRef
   @param str   ڿ  ('\0'     ֽϴ.)
   @param len   ڿ 
   @return      Ӱ  ArrayRef 
*/
extern RvValue *RvStr2ArrayRef (RvObject *, char *, int);

/**
   Field  ϴ ԼԴϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
*/
extern int RvSetField (RvObject *self, const char *name, const char *type, ...);

/**
   Field   ԼԴϴ.  Type   ...  Ǵ 
   Ư¡Դϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
 */
extern int RvGetField (RvObject *self, const char *name, const char *type, ...);

/**
   RvGetField () Լ  ԼԴϴٸ,  ϴ  RvValue 
   ü ȯϴ  Ư¡Դϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
 */
extern RvValue *RvGetFieldValue (RvObject *self, const char *name, const char *type);

/**
   ο 迭 (ArrayRef)  մϴ.

   @param self  SELF ObjectRef
   @param len   Ǵ 迭 ⺻ 
   @return       ArrayRef ͸ ȯմϴ.    
                 ߻Ͽ  NULL_OBJECT  ȯϰ ˴ϴ.
 */
extern RvObject *RvArrayNew (RvObject *self, int len);

/**
   迭 ARRAY  Ÿ TYPE  ׸ Ӱ ߰  ˴ϴ.

   @param array ArraryRef 
   @param type  Ӱ ߰Ǵ ׸ Ÿ ڿ
   @return       0, н -1  ȯմϴ.
 */
extern int RvArrayPush (RvObject *array, const char *type, ...);

/**
   迭 ARRAY    ִ entry  մϴ.

   @param array         ArrayRef 
   @param poped_value    Լ  poped Ǵ RvValue ü  
                         ݴϴ.
   @return       0, н -1  ȯմϴ.
 */
extern int RvArrayPop (RvObject *array, RvValue **poped_value);

extern char * RvArray2Str (RvObject *self, RvObject *array);

/**
   迭 ARRAY   ̸ Ͽ ȯմϴ.

   @param array ArrayRef 
   @return       迭 ũ
 */
extern int RvArrayLength (RvObject *array);

/**
   迭 ARRAY   ()  ִ  Ͽ ׿  RvValue ü
   ȯմϴ.

   @param array ArrayRef 
   @return        ü RvValue ü
 */
extern RvValue *RvArrayLastValue (RvObject *array);

/**
   ڿ STR ̰ ̰ LEN  StringRef  ȯѴ.
 */
extern RvObject *RvStrNew (RvObject *self, char *str, size_t len);

/**
   ڿ STR   OFFSET  ϰ  LEN ŭ ߶ װ
   StringRef  ȯϿ ȯմϴ.

   @param self   SELF ObjectRef
   @param str     Ǵ ڿ
   @param offset ڿ 
   @param len    ڸ 
   @return       Ӱ  StringRef, н NULL_OBJECT
 */
extern RvObject *RvStrSubstr (RvObject *self, char *str, int offset, size_t len);

/**
   StringRef  ڿ ̸  PTR  LEN   ȯմϴ.

   @param str   StringRef 
   @param ptr   ڿ  ڿ 
   @param len   ڿ ̸  int 
   @return       0, н -1  ȯմϴ.
 */
extern int RvStrGetInfo (RvObject *str, char **ptr, int *len);

/**
   ڿ ü STR    Ǿ ִ  value   
    ȯմϴ.

   @param str   ڿ ü
   @return       char * .
 */
extern char *RvStrGetPointer (RvObject *str);

/**
   ڿ ü STR  ̸ Ͽ ȯմϴ.

   @param str   ڿ ü
   @return      ڿ 
 */
extern int RvStrSize (RvObject *str);

/**
   ޽ ȯ   Ǵ ԼԴϴ.  TYPE   ...  ˸
   type  ; մϴ.

   @param self  SELF ObjectRef
   @param ret   ޽ °  ret  ͰԴϴ.
   @param type  ȯ Ÿ
   @return       0, н -1  ȯմϴ.
*/
extern int RvSetReturn (RvObject *self, RvValue *ret, const char *type, ...);

/**
      RET   VALUE  ϴµ Ǵ Լν ȯ
   RvValue ״ ϰ   ˴ϴ.

   @param ret   Ȯ  ޽ ȣ 3 ° ڰ Ǵ Դϴ.
   @param value  
   @return       ߻ -1, ׷   0  ȯ
 */
extern int RvSetReturnValue (RvValue *ret, RvValue *value);

/**
    VALUE  StringRef  ȯմϴ.

   @param value   ü
   @return       true   1 , ׷ ʴٸ 0  ȯմϴ.
 */
extern int RvValueIsStringRef (RvValue *value);

/**
    VALUE  StringRef  Ͽ ȯմϴ.

   @return       VALUE  StringRef  , ׿ شϴ ͸ ȯϰ
                ׷ ʴٸ NULL_OBJECT  ȯմϴ.
 */
extern RvObject *RvValueStringRef (RvValue *value);

/**
   RvValue ü ִ  ڿ ȯϿ ȯմϴ.

   @param self  SELF ObjectRef
   @param val   ڿ ȯ val
 */
extern char *RvValue2Str (RvObject *self, RvValue *val);
//extern int RvValue2Int (RvObject *self, RvValue *val);

/**
    VALUE  ArrayRef  ,  Ǿ ִ ArrayRef ͸ 
   ȯմϴ.

   @param value    RvValue ü
   @return       ArrayRef  , ش ArrayRef ͸, ׷
                  NULL_OBJECT  ȯ˴ϴ.
 */
extern RvObject *RvValueArrayRef (RvValue *value);

/**
      O1  O2  Ͽ  ٸ 1  ȯϰ ׷
   ʴٸ 0  ȯմϴ.   ߰  ߻Ͽٸ -1  ȯϰ
   ˴ϴ.   迭  ,  ׸  ȣν 񱳸 ϰ
   Ǹ, ڿ ü , ڿ    ϰ ˴ϴ. 
    ObjectRef   ּҰ  񱳸 ϰ ˴ϴ.   
     ش  ν ̷ ˴ϴ.

   @param o1      1 
   @param o2      2 
   @return       ٸ 1  ȯϰ ׷ ʴٸ 0  ȯմϴ.
                 ߰  ߻Ͽٸ -1  ȯ
 */
extern int RvValueRichCompare (RvValue *o1, RvValue *o2);

/**
    VALUE  纻    ȯϰ ˴ϴ.   Լ ϴ 
   Ȯ  ۼ GC ޸ ͸ û ϰ    GC  
    , ش ü    ϱ ؼ մϴ.

   Ʒ RvMemMalloc ()  ҴǴ ޸𸮴 Delayed Stack Slot  ڵ
   ϵǰ ˴ϴ.

   @param self  ޸   Ǵ Object ü
   @param value  
   @return       
 */
extern RvValue *RvValueCopy (RvObject *self, RvValue *value);

/**
   GC ޸  Ҵ  Ǵ ԼԴϴ.  Ʒ ҴǴ ޸𸮴
   ڵ Delayed Stack Slot  ϵǰ ˴ϴ.

   @param self  ROVM ü TICKET ü ͸   Ǵ
                ü
   @param size  Ҵ ޸ ũ
   @return      Ҵ ޸ 
 */
extern void *RvMemMalloc (RvObject *self, size_t size);

/**
   VAL  Ÿ ̸ ȯմϴ.

   @param val   ˰ ϴ 
   @return      ش Ÿ ̸
 */
extern const char *RvGetTypeName (RvValue *val);

/**
   ROVM Request  ߻ϴ  ޼ ϱ ؼ ϴ logger Լ.

   @param self	SELF ü
   @param level  α 赵 
   @param file	޼ ߻  ̸
   @param line	޼ ߻   ȣ
   @param fmt	vprintf  
 */
extern int RvLogError (RvObject *, int, const char *, int, const char *, ...);

/**
   迭 ü ARRAY  index IDX  ϴ  ü ȯմϴ.

   @param array 迭 ü
   @param idx   ã index ȣ
   @return      ã  ü ȯ
 */
extern RvValue *RvArrayGetItem (RvObject *array, size_t idx);

/**
   迭 ü ARRAY  index IDX   VAL  ϴ ԼԴϴ.

   @param array 迭 ü
   @param idx     index ȣ
   @param val    
   @return       ߻ -1,  0
 */
extern int RvArraySetItem (RvObject *array, size_t idx, RvValue *val);

/**
   迭 ü ARRAY   TOTAL  ũ⸦ մϴ.  ̿  
   迭 ü ʵ LEN  ǰ ˴ϴ.

   @param array 迭 ü
   @param total 迭  
   @return       ߻ -1,  0  ȯմϴ.
 */
extern int RvArrayResize (RvObject *array, int total);

/**
   迭 ü ARRAY  index WHERE   FMT  ְ ˴ϴ.  FMT  ٷ
   ִ  ƴ϶ ...  ° ؼ  ˸°  ˴ϴ.

   @param array 迭 ü
   @param where   ΰ ϴ index ȣ
   @param fmt   ڿ 
   @return       ߰  ߰ߵǾ  -1, ׷  
                0  ȯϰ ˴ϴ.
 */
extern int RvArrayInsert (RvObject *array, int where, const char *fmt, ...);

/**
   迭 ü ARRAY  LO  HI  ó  ˴ϴ.   V  NULL
     del ARRAY[LO:HI]   ǹ̰ Ǹ, ׷   
   ARRAY[LO:HI] = v  ǹ̰ ˴ϴ.

   ̽ ڵ尡 ſ  Ǿϴ. ^^   ٽ Ӹ ؼ
     󿡼  Ⱦմϴ.

   @param array 迭 ü
   @param lo    迭 lowest index
   @param hi    迭 highest index
   @param v      , ׿ شϴ 
   @return          ߻߾ٸ -1  ׷ ʴٸ 0  
                ȯմϴ.
 */
extern int RvArraySliceAdvanced (RvObject *array, int lo, int hi, RvObject *v);

/**
   Array  Լν SELF  B   ArrayRef üԴϴ.   Լ
   B   ִ ׸  SELF  ߰ϴ  մϴ.

   @param self  迭 ü 1 
   @param b     迭 ü 2 
   @return      迭 ü 2  迭 ü 1   Ե 
                µ,   ߻Ͽ  -1  ׷
                  0  ȯմϴ.
 */
extern int RvArrayExtend (RvObject *self, RvObject *b);

/**
   迭 ü ARRAY   ݴ ϴ.

   @param array 迭 ü
   @return       ߻ -1,  0  ȯ
 */
extern int RvArrayReverse (RvObject *array);

/**
   迭 ü ARRAY  ε I   POP ϰ  POP   POPED_VALUE
    ϰ ˴ϴ.   迭 ߰ κ POP  , ڵ  
   پ ˴ϴ.

   @param array 迭 ü
   @param i     POP  ׸ ε
   @param poped_value POP  ׸ ִ 
   @return       ߻ -1,  0  ȯմϴ.
 */
extern int RvArrayPopWithIndex (RvObject *array, int i, RvValue **poped_value);

/**
   迭 ü ARRAY    Ǵ  ʵ VALUE  ּ ͸
   ȯϰ ˴ϴ.

   迭 ü ڿ ü ʵ VALUE  Ѵ  Ưϰ ϴ
   κ մϴ.

   @param array 迭 ü
   @return      ʵ VALUE  ּ 
 */
extern RvValue *RvArrayGetEntry (RvObject *array);

/**
    ENTRY  RvValue ü ̷ 迭̶  ϰ, ش IDX 
   ´ Ͱ ȯϰ ˴ϴ.

   @param entry RvValue ü 
   @param idx   迭 index ȣ
   @return      ش  
 */
extern RvValue *RvValueEntryItem (RvValue *entry, int idx);

extern RvObject *RvObjectNew (RvObject *self, int iptype, char *hostname, unsigned short port, char *path);

#endif
