/* clstree.c - Class Tree  Ǵ tree ˰
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdio.h>

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"

#include "log.h"
#include "utils.h"
#include "ticket.h"

/*
  (2005-02-05)  clstree  Ticket Tree  ϰ ִ SplayTree 
  ״ ߿ ֽϴ.  Class Tree   ϰ    
   ã Ͽ Դϴ.
*/

/*   Class Tree   tree function  wrapper  Ǿ ֽϴ.  
   ̷ ϴ    ׽Ʈ ̸ܰ, ̸ ְ tree  
     Ͽ Դϴ.  */

/**
   CLSTREE  ϳ node key    ȣǴ callback Լ.

   @param k	 node key
 */
void
rovm_clstree_delete_key (k)
     clstree_key k;
{
  char *tid = (char *) k;

  if (tid)
    rc_free (tid);
}

/**
   CLSTREE  ϳ node value    ȣǴ callback Լ.

   @param v	 node value
 */
void
rovm_clstree_delete_value (v)
     clstree_value v;
{
  /* Դϴ.  ̿  Ʈ ʿմϴ.  */
}

/**
   clstree SP  key  value  Ѵ.

   @note	Wrapper Function Դϴ.

   @param sp	 Class Tree
   @param key	 key 
   @param value  value 
   @return	   Ǿٸ 0 , ׷ ʴٸ -1  ȯѴ.
*/
int
clstree_insert (sp, key, value)
     clstree_t *sp;
     char *key;
     void *value;
{
  splay_tree_node_t n;

  if (!sp || !key)
    return -1;

  n = splay_tree_insert (sp, (splay_tree_key) key, (splay_tree_value) value);
  if (!n)
    return -1;

  return 0;
}

/**
   clstree SP  KEY   key  value  ** Ѵ.

   @param sp    Class Tree 
   @param key    Class  (PATH)
 */
void
clstree_remove (sp, key)
     clstree_t *sp;
     char *key;
{
  splay_tree_key backup;
  splay_tree_node_t n = splay_tree_lookup (sp, (clstree_key) key);

  if (!n)
    return;

  backup = n->key;
  /* !! splay_tree_remove () Լ Node  Value   key 
      ʱ , ̸ Ʒ key  ش.  */
  splay_tree_remove (sp, (splay_tree_key) n->key);
  rovm_clstree_delete_key (backup);
}

/**
   clstree SP  key  KEY  node  ã´.     ,
   NULL  ȯϸ, ߰Ͽ , ش value  ȯѴ.

   @note	Wrapper Function Դϴ.

   @param sp	 Class Tree
   @param key	˻  key 
   @return	߰ key  value  ȯѴ.   ʴ ٸ, NULL 
                ȯѴ.
 */
void *
clstree_lookup (sp, key)
     clstree_t *sp;
     char *key;
{
  splay_tree_node_t n = splay_tree_lookup (sp, (clstree_key) key);

  if (!n)
    return NULL;

  return (void *) n->value;
}

/**
   ο Class Tree  Ѵ.

   @note	Wrapper Function Դϴ.

   @param compare_fn		Tree  compare function
   @param delete_key_fn		Tree  key     Լ.
   @param delete_value_fn	Tree  value     Լ.
   @return   Class Tree ȯѴ.
 */
clstree_t *
init_clstree (compare_fn, delete_key_fn, delete_value_fn)
     clstree_compare_fn compare_fn;
     clstree_delete_key_fn delete_key_fn;
     clstree_delete_value_fn delete_value_fn;
{
  return (clstree_t *) splay_tree_new (compare_fn, delete_key_fn, delete_value_fn);
}

/**
    ̻ Class Tree  ʿ , ش ׵    Ѵ.

   @note	Wrapper Function Դϴ.

   @param tk	 clstree_t ü.
 */
void
finish_clstree (tk)
     clstree_t *tk;
{
  splay_tree_delete (tk);
}

/**
   Splay Tree  ƾ.  K1  K2   , 0  ȯѴ.  ׷  ,
   -1 Ȥ 1  ȯȴ.

   @param k1 Key 1 
   @param k2 Key 2 
   @return  K1  K2    0  ȯѴ.
*/
int
rovm_clstree_compare (k1, k2)
     clstree_key k1;
     clstree_key k2;
{
  return strcmp ((char *) k1, (char *) k2);
}

/**
   ROVM ü clstree  ʱȭմϴ.

   @param r	ROVM ü 
   @return	 Ǿ  0 , ׷ ʴٸ -1  ȯѴ.
 */
int
init_rovm_clstree (r)
     struct rovm *r;
{
  ROVM_CLSTREE (r) = init_clstree ((clstree_compare_fn) rovm_clstree_compare,
                                   (clstree_delete_key_fn) rovm_clstree_delete_key,
                                   (clstree_delete_value_fn) rovm_clstree_delete_value);
  if (!ROVM_CLSTREE (r))
    return -1;
  
  return 0;
}

