#ifndef _ROVMI_ROVM_H
#define _ROVMI_ROVM_H

#include "types.h"

#define ROVMLOG_EMERG           0       /* system is unusable */
#define ROVMLOG_ALERT           1       /* action must be taken immediately */
#define ROVMLOG_CRIT            2       /* critical conditions */
#define ROVMLOG_ERR             3       /* error conditions */
#define ROVMLOG_WARNING         4       /* warning conditions */
#define ROVMLOG_NOTICE          5       /* normal but significant condition */
#define ROVMLOG_INFO            6       /* informational */
#define ROVMLOG_DEBUG           7       /* debug-level messages */

typedef struct rovmret rovmret_t;
typedef struct rovm rovm_t;
typedef struct rovmres rovmres_t;

struct rovmerror
{
  char *msg;
  int level;

  struct rovmerror *next;
};

#define TICKET_SIZE     20

struct rovmstr
{
  char *ptr;
  size_t len;
};

#define RETTYPE_VOID            0x00
#define RETTYPE_ARRAYREF        0x01
#define RETTYPE_BOOLEAN         0x02
#define RETTYPE_CHAR            0x03
#define RETTYPE_SHORT           0x04
#define RETTYPE_INT             0x05
#define RETTYPE_FLOAT           0x06
#define RETTYPE_DOUBLE          0x07
#define RETTYPE_OBJREF          0x08
#define RETTYPE_STRINGREF       0x09

struct rovmarray
{
  char type;

  union
  {
    int _int;
    struct rovmarray *_array;
    struct rovmstr *_string;
  } v;  
};

struct rovmret
{
  char type;
  int is_array;
  size_t arraylen;

  union
  {
    int _int;
    struct rovmarray *_array;
    struct rovmstr *_string;
  } v;
};

struct rovmops
{
  void (*ipush) (rovm_t *r, int);
  void (*spush) (rovm_t *r, const char *buf, size_t len);
  void (*call) (rovm_t *r, const char *mname, const char *mtype);
};

#define DEFAULT_OPCODE_LEN      1024

struct rovm
{
  const char *host;
  apr_port_t port;
  unsigned char ticket[TICKET_SIZE];

  apr_pool_t *p;
  apr_socket_t *sock;

  struct rovmerror *errmsg;

  unsigned char *op;
  size_t oplen;
  size_t max_oplen;

  struct rovmops ops;

  rovmret_t *(*send) (rovm_t *r);
  void (*printerror) (rovm_t *r);
  void (*printstack) (rovm_t *r);
  void (*printreturn) (rovm_t *r, rovmret_t *ret);
};

struct rovmres
{
  char type;
};

extern rovm_t * rovm_req (const char *host, apr_port_t port);
extern void rovm_reqend (rovm_t *r);

#endif
