/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_MPM_WORKER_POD_H
#define _ROVM_MPM_WORKER_POD_H

#define RC_POD_NORESTART                APR_OS_START_USEERR + 1
#define RC_POD_RESTART  0
#define RC_POD_GRACEFUL 1

/**
   Pipe-of-death  ü.
 */
struct rc_pod_t 
{
  rc_file_t *pod_in;
  rc_file_t *pod_out;
  rc_pool_t *p;
  struct rovm *r;
};

extern rc_status_t rc_mpm_pod_open (rc_pool_t *p, rc_pod_t **pod, struct rovm *);
extern rc_status_t rc_mpm_pod_check (rc_pod_t *pod);
extern rc_status_t rc_mpm_pod_close (rc_pod_t *pod);
extern rc_status_t rc_mpm_pod_signal (rc_pod_t *pod);
extern void rc_mpm_pod_killpg (rc_pod_t *pod, int num);

#endif
