#include <stdarg.h>

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "ticket.h"
#include "file.h"

#include "el.h"
#include "gc.h"

/**
   FDS  ǵǾ ִ field  Ŭ CLS   field  Ѵ.

   @param cls    Class   Ŭ  
   @param fds   Field  Ǿ ִ ü .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
 */
int
RvDefineFields (RvClass *cls, RvFieldDef *fds)
{
  RvFieldDef *fd = fds;

  while (fd->name)
    {
      RvField *f;

      if (rc_find_efield (cls, (u1 *) fd->name, (u1 *) fd->type))
        return 0;

      f = init_efield (cls, (u1 *) fd->name, (u1 *) fd->type);
      if (!f)
        return -1;

      FIELD_NEXT (f) = CLASS_FIELD (cls);
      CLASS_FIELD (cls) = f;

      fd++;
    }

  return 0;
}

/**
   CLS  MDS  о ش Method  ǵ CLS ο Ѵ.

   @param cls    Class   Ŭ  
   @param mds   Method  Ǿ ִ .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
 */
int
RvDefineMethods (RvClass *cls, RvMethodDef *mds)
{
  RvMethodDef *md = mds;

  while (md->name)
    {
      RvMethod * m;

      if (rc_find_emethod (cls, (u1 *) md->name, (u1 *) md->type))
        return 0;

      /* Native Function  ȣ  ֵ method  մϴ.  */
      m = init_emethod ((u1 *) md->name, (u1 *) md->type);
      if (!m)
        return -1;

      METHOD_FLAG (m) |= ACCESS_NATIVE;
      METHOD_NATIVE (m) = md->func;
      METHOD_NEXT (m) = CLASS_METHOD (cls);
      
      CLASS_METHOD (cls) = m;

      md++;
    }

  return 0;
}

/**
   ObjectRef  ڰ Ÿ   ˴ϴ.

   @param self   ObjectRef
   @param idx     index ȣ (ݵ OBJECT_MAX_USERDATA 
                 ۾ƾ մϴ.
   @param value  .
*/
int
RvSetUserData (RvObject *self, int idx, void *value)
{
  if (idx >= OBJECT_MAX_USERDATA)
    return -1;

  OBJECT_USERDATA_IDX (self, idx) = (unsigned long) value;

  return 0;
}

/**
   ObjectRef  ڰ  Ÿ  , Ѵ.

   (ܺ  Լ)

   @param self   ObjectRef
   @param idx    Ÿ index ȣ
   @return      ڰ   ȯմϴ.
*/
void *
RvGetUserData (RvObject *self, int idx)
{
  if (!self || idx >= OBJECT_MAX_USERDATA || idx < 0)
    return NULL;

  return (void *) OBJECT_USERDATA_IDX (self, idx);
}

/**
   ARGS  FMT  Ͽ ش  ùٸ   ִ Ȱ ϴ
   ԼԴϴ.

   (ܺ  Լ)

   @param args  RvValue üԴϴ.  ̰ Stack Slot   ͸
                 ˴ϴ.
   @param fmt   ؼ Դϴ.
   @return        0 , ׷   -1  ȯѴ.
*/
int
RvParseArg (RvObject *self, RvValue *args, const char *fmt, ...)
{
  va_list ap;
  int idx;
  char *p = (char *) fmt;

  va_start (ap, fmt);

  idx = 0;
  while (*p)
    {
      RvValue *col = args + idx;

      switch (*p)
        {
        case 's':
          {
            char **s = va_arg (ap, char **);
            RvValue *value;
            RvObject *strobj;

            if (STACK_TYPE (col) != STACK_TYPE_STRINGREF)
              goto error;

            strobj = GET_STACK_V_STRINGREF (col);
            value = RvGetFieldValue (strobj, "value", "[");
            if (!value)
              goto error;
            *s = RvValue2Str (strobj, value);

            if (p[1] == '#')
              {
                int *len = va_arg (ap, int *);

                p++;
                if (RvGetField (strobj, "len", "I", len))
                  goto error;
              }
            break;
          }
        case 'i':
          {
            int *i = va_arg (ap, int *);
           
            if (STACK_TYPE (col) != STACK_TYPE_INT)
              goto error;

            *i = GET_STACK_VALUE (INT, col);
            break;
          }
        default:
          goto error;
          break;
        }

      idx++;
      p++;
    }

  va_end (ap);

  return 0;

 error:
  va_end (ap);

  return -1;
}

/**
   Field  ϴ ԼԴϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
 */
int
RvSetField (RvObject *self, const char *name, const char *type, ...)
{
  va_list ap;
  RvValue *val;

  va_start (ap, type);

  val = rc_getfieldvalue (self, (u1 *) name, (u1 *) type);
  if (!val)
    goto error;

  switch (type[0])
    {
    case 'I':
      {
        int v = va_arg (ap, int);

        STACK_TYPE (val) = STACK_TYPE_INT;
        GET_STACK_VALUE (INT, val) = v;
        break;
      }
    default:
      goto error;
    }

  va_end (ap);
  return 0;

 error:
  va_end (ap);
  return -1;
}

char *
RvArray2Str (RvObject *self, RvObject *array)
{
  RvValue *val;

  if (!self || !array)
    return "(error)";

  if (!OBJECT_IS_ARRAY (array))
    return "(error)";

  val = rc_getfieldvalue (array, "value", "[");
  if (!val)
    return "(error)";

  if (STACK_IS_STRINGVALUE (val))
    {
      char *p = (char *) GET_STACK_VALUE (ADDR, val);
      RvValue *v2;

      v2 = RvGetFieldValue (array, "len", "I");
      if (!v2)
        return "(broken_string)";
      
      return gc_strndup (OBJECTL_ROVM (self), OBJECT_TICKET (self), p, GET_STACK_VALUE (INT, v2));
    }
  else
    return "(can't process)";

  return "(error)";
}

/**
   RvValue  ڿ ȯϿ ȯմϴ.
 */
char *
RvValue2Str (RvObject *self, RvValue *val)
{
  if (!self || !val)
    return NULL;

  switch (STACK_TYPE (val))
    {
    case STACK_TYPE_VOID:
      return "(void)";
    case STACK_TYPE_BOOLEAN:
      return "(boolean)";
    case STACK_TYPE_CHAR:
      return "(char)";
    case STACK_TYPE_SHORT:
      return "(short)";
    case STACK_TYPE_INT:
      return "(int)";
    case STACK_TYPE_FLOAT:
      return "(float)";
    case STACK_TYPE_DOUBLE:
      return "(double)";
    case STACK_TYPE_OBJREF:
      return "(objref)";
    case STACK_TYPE_STRINGREF:
      return "(stringref)";
    case STACK_TYPE_ARRAYREF:
      {
        if (STACK_IS_STRINGVALUE (val))
          {
            char *p = (char *) GET_STACK_VALUE (ADDR, val);
            RvValue *v2;

            if (!OBJECT_IS_STRING (self))
              return "(invalid StringRef)";

            v2 = RvGetFieldValue (self, "len", "I");
            if (!v2)
              return "(broken_string)";
            
            return gc_strndup (OBJECTL_ROVM (self), OBJECT_TICKET (self), p, GET_STACK_VALUE (INT, v2));
          }
        else
          return "(can't process)";
        break;
      }
    default:
      break;
    }

  return "(unknown)";
}

/**
   RvValue   ȯϿ ȯմϴ.
 */
static int
RvValue2Int (RvObject *self, RvValue *val)
{
  if (!self || !val)
    return 0;

  switch (STACK_TYPE (val))
    {
    case STACK_TYPE_BOOLEAN:
    case STACK_TYPE_SHORT:
    case STACK_TYPE_CHAR:
    case STACK_TYPE_INT:
      return GET_STACK_VALUE (INT, val);
    default:
      break;
    }

  return 0;
}

/**
   Ÿ FTYPE   ʵ FNAME  SELF  ã ش  Ǵ
    RvValue ü ȯϰ Ǵϴ.

   @param self  SELF ü.
   @param fname ʵ ̸
   @param ftype ʵ Ÿ
   @return      SELF  ϴ ʵ带   ȯմϴ.
 */
RvValue *
RvGetFieldValue (RvObject *self, const char *fname, const char *ftype)
{
  RvValue *val;

  if (!self || !fname || !ftype)
    return NULL_VALUE;

  val = rc_getfieldvalue (self, fname, ftype);
  if (!val)
    return NULL_VALUE;

  return val;
}

int
RvGetField (RvObject *self, const char *fname, const char *ftype, ...)
{
  va_list ap;
  RvValue * val;

  if (!self || !fname || !ftype)
    return -1;

  val = rc_getfieldvalue (self, fname, ftype);
  if (!val)
    return -1;

  va_start (ap, ftype);

  switch (ftype[0])
    {
    case '[':
      {
        RvObject **o = va_arg (ap, RvObject **);

        *o = GET_STACK_VALUE (ARRAYREF, val);
        break;
      }
    case 'I':
      {
        int *i = va_arg (ap, int *);

        *i = RvValue2Int (self, val);
        break;
      }
    default:
      return -1;
    }

  va_end (ap);
  return 0;
}

/**
   TYPE  迭 Ͽ ش ͸ ȯմϴ.
 */
RvObject *
RvArrayNew (RvObject *self)
{
  if (!self)
    return NULL_OBJECT;

  return NewRvArray (OBJECTL_ROVM (self), OBJECT_TICKET (self), 0);
}

int
RvArrayPush (RvObject *array, const char *type, ...)
{
  int arrlen;
  RvValue *entry;
  va_list ap;

  if (!array || !type)
    return -1;

  va_start (ap, type);

  if (rc_expandarray (array, 1))
    {
      va_end (ap);
      return -1;
    }

  if (rc_getinfo_array (array, &entry, &arrlen))
    {
      va_end (ap);
      return -1;
    }

  entry = entry + arrlen;

  switch (type[0])
    {
    case 'S':
      {
        RvObject *o = va_arg (ap, RvObject *);

        GET_STACK_VALUE (ADDR, entry) = (void *) o;
        STACK_TYPE (entry) = STACK_TYPE_STRINGREF;
        break;
      }
    default:
      va_end (ap);
      return -1;
    }

  if (RvSetField (array, "len", "I", arrlen + 1))
    return -1;

  return 0;
}

int
RvArrayPop (RvObject *array)
{
  int len;

  len = RvArrayLength (array);
  if (len < 0)
    return -1;

  if (RvSetField (array, "len", "I", len - 1))
    return -1;  

  return 0;
}

/**
   ڿ STR ̰ ̰ LEN  StringRef  ȯѴ.
 */
RvObject *
RvStrNew (RvObject *self, char *str, size_t len)
{
  return NewRvStringObject (OBJECTL_ROVM (self), OBJECT_TICKET (self),
                            str, len);
}

/**
   ڿ ߶ ׿  StringRef  ȯѴ.
 */
RvObject *
RvStrSubstr (RvObject *self, char *str, int offset, size_t len)
{
  return NewRvStringObject (OBJECTL_ROVM (self), OBJECT_TICKET (self),
                            str + offset, len);
}

/**
   Return  TYPE   մϴ.
 */
int
RvSetReturn (RvObject *self, RvValue *ret, const char *type, ...)
{
  va_list ap;

  if (!self || !ret || !type)
    return -1;

  va_start (ap, type);

  switch (type[0])
    {
    case 'V':
      SET_STACK_TYPE (ret, STACK_TYPE_VOID);
      break;
    case 'B':
      SET_STACK_VALUE (ret, BOOLEAN, (unsigned char) va_arg (ap, int));
      break;
    case 'C':
      SET_STACK_VALUE (ret, CHAR, (char) va_arg (ap, int));
      break;
    case 'H':
      SET_STACK_VALUE (ret, SHORT, (short) va_arg (ap, int));
      break;
    case 'I':
      SET_STACK_VALUE (ret, INT, (int) va_arg (ap, int));
      break;
    case 'F':
      SET_STACK_VALUE (ret, FLOAT, (float) va_arg (ap, double));
      break;
    case 'D':
      SET_STACK_VALUE (ret, DOUBLE, (double) va_arg (ap, double));
      break;
    case 'T':
      SET_STACK_VALUE (ret, OBJREF, (void *) va_arg (ap, RvObject *));
      break;
    case 'S':
      SET_STACK_VALUE (ret, STRINGREF, (void *) va_arg (ap, RvObject *));
      break;
    case '[':
      SET_STACK_VALUE (ret, ARRAYREF, (void *) va_arg (ap, RvObject *));
      break;
    default:
      break;
    }

  va_end (ap);
  return 0;
}

int
RvStrGetInfo (RvObject *str, char **ptr, int *len)
{
  RvValue *value;

  /* StringRef  ArrayRef  value  Ưϰ   Ѵ.  */
  value = RvGetFieldValue (str, "value", "[");
  if (!value)
    return -1;
  *ptr = RvValue2Str (str, value);

  if (RvGetField (str, "len", "I", len))
    return -1;

  return 0;
}

int
RvArrayLength (RvObject *array)
{
  int len;

  if (RvGetField (array, "len", "I", &len))
    return -1;
  
  return len;
}

RvValue *
RvArrayLastValue (RvObject *array)
{
  int len;
  RvValue *value, *entry;

  len = RvArrayLength (array);
  if (len <= 0)
    return NULL_VALUE;

  /* StringRef  ArrayRef  value  Ưϰ   Ѵ.  */
  value = RvGetFieldValue (array, "value", "[");
  if (!value)
    return NULL_VALUE;

  if (!STACK_IS_ARRAYVALUE (value))
    return NULL_VALUE;

  entry = (RvValue *) GET_STACK_VALUE (ADDR, value);

  return &entry[len - 1];
}

int
RvValueIsStringRef (RvValue *value)
{
  if (STACK_TYPE (value) == STACK_TYPE_STRINGREF)
    return TRUE;

  return FALSE;
}

RvObject *
RvValueStringRef (RvValue *value)
{
  if (!RvValueIsStringRef (value))
    return NULL_OBJECT;

  return GET_STACK_V_STRINGREF (value);
}
