/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"

/*
   Ͽ   memory pool   wrapper  Ǿ ֽϴ.
  ̷ ϴ   ׽Ʈ ̱   memory pool 
  ã      ֵ ϱ ؼ Դϴ.

  !Ʈ! ũθ ̿ ʴ   ؼ Դϴ.
 */

/**
   Memory Pool  ʱȭմϴ.    ʱȭϱ  ̸,  
     ѹ ȣǾ մϴ.
 */
void
init_mp (void)
{
  apr_pool_initialize ();
}

/**
   Memoru Pool  ϴ.     ѹ ȣǾ մϴ.
 */
void
finish_mp (void)
{
  apr_pool_terminate ();
}

/**
   Memory Pool  մϴ.

   @param c	ʱȭ rc_pool_t 
   @param p	θ rc_pool_t 
 */
int
mp_create (c, p)
     rc_pool_t **c, *p;
{
  return apr_pool_create (c, p);
}

/**
   Memory Pool  մϴ.

   @param n     Ӱ  rc_pool_t 
   @param p     θ rc_pool_t 
   @param fn    Abort Function
   @param a     Allocator 
 */
rc_status_t
mp_create_ex (rc_pool_t **n,
              rc_pool_t *p,
              rc_abortfunc_t fn,
              rc_allocator_t *a)
{
  return apr_pool_create_ex (n, p, fn, a);
}

/**
   Ҵ Memory Pool  մϴ.

   @param c	ü rc_pool_t 
 */
int
mp_destroy (c)
     rc_pool_t *c;
{
  apr_pool_destroy (c);

  return 0;
}

/**
   ޸𸮸 calloc · Ҵմϴ.

   @param c	 rc_pool_t 
   @param size	Ҵ ޸ ũ
 */
void *
mp_calloc (c, size)
     rc_pool_t *c;
     size_t size;
{
  return apr_pcalloc (c, size);
}

/**
   ޸𸮸 malloc · Ҵմϴ.

   @param c	 rc_pool_t 
   @param size	Ҵ ޸ ũ
 */
void *
mp_alloc (c, size)
     rc_pool_t *c;
     size_t size;
{
  return apr_palloc (c, size);
}

/**
   Pool  tag ũѴ.  (give it a name)

   @param p	Tag ũ  pool
   @param t	Tag ̸
*/
void
mp_tag (p, t)
     apr_pool_t *p;
     const char *t;
{
  apr_pool_tag (p, t);
}

/**
   ޸ poll  P  Ҹ ,  Ҹ  callback  մϴ.

   @param p             ش ޸ pool
   @param data          
   @param plain_cleanup Plain CleanUp
   @param child_cleanup Child CleanUp
 */
void
mp_cleanup_register (rc_pool_t *p,
                     const void *data,
                     rc_status_t (*plain_cleanup) (void *),
                     rc_status_t (*child_cleanup) (void *))
{
  apr_pool_cleanup_register (p, data, plain_cleanup, child_cleanup);
}

/**
   Allocator  մϴ.

   @param a     ʱȭ Allocator 
*/
rc_status_t
rc_allocator_create (rc_allocator_t **a)
{
  return apr_allocator_create (a);
}

/**
   Allocator   ޸ Ǯ մϴ.

   @param a     Allocator
   @param p     ޸ Ǯ
 */
void
rc_allocator_owner_set (rc_allocator_t *a, rc_pool_t *p)
{
  apr_allocator_owner_set (a, p);
}

/**
   Pool   ޸𸮸 ,  cleanup  մϴ.

   @param p      pool
 */
void
mp_clear (rc_pool_t *p)
{
  apr_pool_clear (p);
}

/**
     pool  õ userdata  Ѵ.

   @param data           data
   @param key           Key 
   @param cleanup       Cleanup Լ
   @param pool           ޸ pool
 */
rc_status_t
mp_userdata_set (const void *data,
                 const char *key,
                 rc_status_t (*cleanup)(void *),
                 rc_pool_t *pool)
{
  return apr_pool_userdata_set (data, key, cleanup, pool);
}

/**
     pool   userdata  ´.

   @param data           data buffer
   @param key           Key 
   @param pool           ޸ pool
 */
rc_status_t
mp_userdata_get (void **data, const char *key,
                 rc_pool_t *pool)
{
  return apr_pool_userdata_get (data, key, pool);
}

/**
   ޸ Ǯ  Ͽ ڿ S  Ͽ ȯѴ.

   @param p      ޸ pool
   @param s      ڿ 
*/
char *
mp_strdup (rc_pool_t *p, const char *s)
{
  return apr_pstrdup (p, s);
}
