#include <stdlib.h>

#include "types.h"
#include "mpool.h"
#include "clstree.h"
#include "tktree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

#include "class.h"

#define EFILE_PATH(NODE)                ((NODE)->filepath)
#define EFILE_BUFBASE(NODE)             ((NODE)->bufbase)
#define EFILE_BUFCUR(NODE)              ((NODE)->bufcur)
#define EFILE_BUFCUR_IDX(NODE, IDX)	((NODE)->bufcur[(IDX)])
#define EFILE_BUFLEN(NODE)              ((NODE)->buflen)

struct efile
{
  /**  óϰ ִ File  .  */
  u1 *filepath;

  u1 *bufbase;
  u1 *bufcur;
  u4 buflen;
};

/**
    EF κ 1 Ʈ C  ϰ, ġ ̵Ѵ.  
*/
static void
readu1 (ef, c)
     struct efile *ef;
     u1 *c;
{
  *c = EFILE_BUFCUR_IDX (ef, 0);
  EFILE_BUFCUR (ef) += 1;
}

/**
   EF κ 1 Ʈ C  ϰ, ġ ̵Ѵ.  
*/
static void 
readu2 (ef, c)
     struct efile *ef;
     u2 *c;
{
  *c = ((u2 *) &EFILE_BUFCUR_IDX (ef, 0))[0];
  EFILE_BUFCUR (ef) += 2;
}

/**
   EF κ 4 Ʈ C  ϰ, ġ ̵Ѵ.  
*/
static void 
readu4 (ef, c)
     struct efile *ef;
     u4 *c;
{
  *c = ((u4 *) (&EFILE_BUFCUR_IDX (ef, 0)))[0];
  EFILE_BUFCUR (ef) += 4;
}

/**
   struct environment_file  LEN*SIZE ŭ о, DEST 
   Ѵ.
*/
static void
readm (ef, dest, len, size)
     struct efile *ef;
     void *dest;
     size_t len;
     size_t size;
{
  int tsize = len * size;

  memcpy (dest, EFILE_BUFCUR (ef), tsize);
  EFILE_BUFCUR (ef) += tsize;
}

/**
   ROVM   ClassRoot  PATH  Ͽ ü θ ϼϿ
   ȯմϴ.

   @param r     ROVM ü
   @param path  Class   
 */
static char *
efile_getfullpath (r, path)
     struct rovm *r;
     char *path;
{
  char *ret;

  if (!r || (r && !CONF_CLASSROOT (ROVM_CONF (r))))
    return NULL;

  ret = (char *) rc_calloc (1, 
                            strlen (CONF_CLASSROOT (ROVM_CONF (r))) 
                            + strlen (path) 
                            + strlen (DEFAULT_ENVLANG_EXTENSION)
                            + 1);
  strcat (ret, CONF_CLASSROOT (ROVM_CONF (r)));
  strcat (ret, path);
  strcat (ret, DEFAULT_ENVLANG_EXTENSION);

  return ret;
}

/**
    PATH  мϰ ٵ,   ϰ  ⺻   Ÿ
   ȯ ϰ,   struct efile ü ȯѴ.

   @param r     ROVM ü
   @param path  Load  Class  .
 */
static struct efile *
init_efile (r, path)
     struct rovm *r;
     char *path;
{
  char *fullpath;
  FILE *fp;
  size_t read_bytes;
  struct efile *ef;

  fullpath = efile_getfullpath (r, path);
  if (!fullpath)
    return NULL;

  if (!(fp = fopen (fullpath, "rb")))
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "fopen error.");
      rc_free (fullpath);
      return NULL;
    }

  if (fseek (fp, 0L, SEEK_END))
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "fseek error.");
      rc_free (fullpath);
      fclose (fp);
      return NULL;
    }

  ef = (struct efile *) rc_malloc (sizeof (struct efile));
  EFILE_PATH (ef) = fullpath;
  EFILE_BUFLEN (ef) = (int) ftell (fp);
  EFILE_BUFBASE (ef) = EFILE_BUFCUR (ef) = (u1 *) rc_malloc (EFILE_BUFLEN (ef));

  fseek (fp, 0L, SEEK_SET);
  read_bytes = fread (EFILE_BUFBASE (ef), 1, EFILE_BUFLEN (ef), fp);
  if (read_bytes != EFILE_BUFLEN (ef))
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "fread error.");
      rc_free (EFILE_BUFBASE (ef));
      rc_free (fullpath);
      rc_free (ef);
      fclose (fp);
      return NULL;
    }

  fclose (fp);

  return ef;
}

/**
    ̻  ʴ struct efile ü մϴ.

   @param ef     ǽ ü.
 */
static void
finish_efile (ef)
     struct efile *ef;
{
  rc_free (EFILE_PATH (ef));
  rc_free (EFILE_BUFBASE (ef));
  rc_free (ef);
}

/**
   RvClass ü Ӱ ҴϿ ش ͸ ȯѴ.
   
   @return      Ӱ Ҵ RvClass ü.
 */
static RvClass *
init_eclass (void)
{
  RvClass *cls;

  cls = (RvClass *) calloc (1, sizeof (RvClass));

  return cls;
}

/**
   RvMethod  ıմϴ.

   @param m     ı method.
 */
static void
destroy_emethod (m)
     RvMethod *m;
{
#define METHODFREE(NODE) \
  if ((NODE))         \
    rc_free ((NODE))

  METHODFREE (METHOD_NAME (m));
  if (METHOD_TYPE (m))
    {
      METHODFREE (MTYPE_STR (METHOD_TYPE (m)));
      METHODFREE (MTYPE_ARGV (METHOD_TYPE (m)));
      rc_free (METHOD_TYPE (m));
    }
  METHODFREE (METHOD_OP (m));
  rc_free (m); 
}

/**
   RvClass ü  Ѵ.

   @param cls    RvClass ü 
 */
static void
destroy_eclass (cls)
     RvClass *cls;
{
#define CLSFREE(NODE) \
  if ((NODE))         \
    rc_free ((NODE))

  if (!cls)
    return;

  CLSFREE (CLASS_NAME (cls));

  if (CLASS_METHOD (cls))
    {
      RvMethod *next, *m = CLASS_METHOD (cls);

      while (m)
        {
          next = METHOD_NEXT (m);

          destroy_emethod (m);

          m = next;
        }
    }

  rc_free (cls);
}

/**
   RvClass ü Ӱ ҴϿ ش ͸ ȯѴ.
   
   @return      Ӱ Ҵ RvClass ü.
 */
static RvMethod *
init_emethod (void)
{
  RvMethod *m;

  m = (RvMethod *) calloc (1, sizeof (RvMethod));

  return m;
}

/**
   Ŭ CLS  ޽  NAME  TYPE    ã ȯѴ.

   @param cls   Ŭ 
   @param name  ã ޽ ̸
   @param type  ã Ÿ ̸
   @return      ã ޽, ߰ Ͽ , NULL_METHOD  ȯմϴ.
 */
RvMethod *
rc_find_emethod (cls, name, type)
     RvClass *cls;
     u1 *name, *type;
{
  RvMethod *m;

  if (!cls || !name || !type)
    return NULL_METHOD;

  m = CLASS_METHOD (cls);

  while (m)
    {
      if (!strcmp (METHOD_NAME (m), name)
          && METHOD_TYPE (m)
          && !strcmp (MTYPE_STR (METHOD_TYPE (m)), type))
        return m;

      m = METHOD_NEXT (m);
    }

  return NULL_METHOD;
}

/**
   Method Type  TYPE  ؼϿ Argument   ȯѴ.

   @param type  ؼ Method Type ڿ
   @return      ؼ argument  
 */
static u2
calctype_argc (path)
     u1 *path;
{
  int idx = 0;
  u1 *p = path;

  while (*p != '\0')
    {
      switch (*p)
        {
        case 'S':
        case 'I':
          idx++;
        case '(':
          break;
        case ')':
          return idx;
          break;
        default:
          rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Can't handle type");
          break;
        }
      p++;
    }

  /*  ϸ ̴.  */
  return 0xffff;
}

/**
   Method Type  TYPE  ؼϿ  Argument  offset  Ͽ ش
   迭 ȯϰ ˴ϴ.

   @param type  ؼ Method Type ڿ
   @param argc   Method Type  argument 
   @return      ؼ argument  offset   迭
 */
static u2 *
calctype_argv (type, argc)
     u1 *type;
     u2 argc;
{
  int idx = 0;
  u1 *p = type;
  u2 *argv = (u2 *) rc_malloc (sizeof (u2) * argc);

  if (!argv)
    return NULL;

  while (*p != '\0')
    {
      switch (*p)
        {
        case 'S':
        case 'I':
          argv[idx++] = (u2) (p - type);
        case '(':
          break;
        case ')':
          return argv;
          break;
        default:
          rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Can't handle type");
          break;
        }
      p++;
    }

  /*  ϸ ̴.  */
  rc_free (argv);

  return NULL;
}

/**
   Method Type  TYPE  ؼϿ return  ִ ڿ  offset 
   ȯմϴ.

   @param type  ؼ Method Type ڿ
   @return      ؼ return  offset .    ִٸ -1 
                ȯϰ ˴ϴ.
 */
static u2
calctype_ret (type)
     u1 *type;
{
  u1 *p = type;

  while (*p != '\0')
    {
      switch (*p)
        {
        case 'S':
        case 'I':
        case '(':
          break;
        case ')':
          return (p - type) + 1;
          break;
        default:
          rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Can't handle type");
          break;
        }
      p++;
    }

  /*  ϸ ̴.  */
  return 0xffff;
}

/**
   Method  Type  ʱȭ  Ǵ Լν, TYPE   
   Ҵ  ش Ÿ ؼϿ   մϴ.

   @param type  ؼ type
   @return      Ӱ  Method Type 
 */
static struct eclass_method_type *
init_emethodtype (type)
     u1 *type;
{
  struct eclass_method_type *mt;

  if (!type || (type && type[0] != '('))
    return NULL;

  mt = (struct eclass_method_type *) rc_malloc (sizeof (struct eclass_method_type));
  MTYPE_STR (mt) = type;
  MTYPE_ARGC (mt) = calctype_argc (type);
  if (MTYPE_ARGC (mt) == 0xffff)
    {
      rc_free (mt);
      return NULL;
    }
    
  MTYPE_ARGV (mt) = calctype_argv (type, MTYPE_ARGC (mt));
  if (!MTYPE_ARGV (mt))
    {
      rc_free (mt);
      return NULL;
    }

  MTYPE_RET (mt) = calctype_ret (type);
  if (MTYPE_RET (mt) == 0xffff)
    {
      rc_free (MTYPE_ARGV (mt));
      rc_free (mt);
      return NULL;
    }

  return mt;
}

/** Ӽ ClassName  쿡  type Դϴ.  */
#define ATTRIBUTE_CLASSNAME     0xff
/** Ӽ Method  쿡  type Դϴ.  */
#define ATTRIBUTE_METHOD        0xfe
/** Ӽ MethodCode  쿡  type Դϴ.  */
#define ATTRIBUTE_METHODCODE    0xfd

/**
   EF κ ϳ attribute  о CLS  ϰ ȴ.
 */
static int
rc_read_attribute (r, arg, ef)
     struct rovm *r;
     void *arg;
     struct efile *ef;
{
  int i;
  u1 attribute_type;
  u4 attribute_length;
  
  readu1 (ef, &attribute_type);
  readu4 (ef, &attribute_length);

  /*
     Ӽ  ڼ  http://envlang.kldp.net/ Ȩ ϴ
     `ENVLANG  '  Ͻñ ٶϴ.
   */
  switch (attribute_type)
    {
    case ATTRIBUTE_CLASSNAME:
      {
        u1 name_len, *name;
        RvClass *cls = (RvClass *) arg;

        readu1 (ef, &name_len);
        name = (u1 *) rc_malloc (name_len + 1);
        readm (ef, name, name_len, 1);
        name[name_len] = '\0';

        if (CLASS_NAME (cls))
          {
            rc_free (name);
            goto error;
          }

        CLASS_NAME (cls) = name;
        break;
      }
    case ATTRIBUTE_METHOD:
      {
        u1 name_len, *name, *type;
        u2 type_len, attribute_counts;
        u4 RESERVED_SPACE;
        RvClass *cls = (RvClass *) arg;
        RvMethod *m;

        m = init_emethod ();

        readu4 (ef, &RESERVED_SPACE);
        
        readu1 (ef, &name_len);
        name = (u1 *) rc_malloc (name_len + 1);
        readm (ef, name, name_len, 1);
        name[name_len] = '\0';

        readu2 (ef, &type_len);
        type = (u1 *) rc_malloc (type_len + 1);
        readm (ef, type, type_len, 1);
        type[type_len] = '\0';

        if (rc_find_emethod (cls, name, type))
          {
            rc_free (type);
            rc_free (name);
            destroy_emethod (m);
            goto error;
          }

        METHOD_NAME (m) = name;
        METHOD_TYPE (m) = init_emethodtype (type);
        if (!METHOD_TYPE (m))
          {
            rc_free (type);
            rc_free (name);
            destroy_emethod (m);
            goto error;
          }

        readu2 (ef, &attribute_counts);
        for (i=0; i<attribute_counts; i++)
          {
            if (rc_read_attribute (r, (void *) m, ef))
              {
                destroy_emethod (m);
                goto error;
              }
          }

        METHOD_NEXT (m) = CLASS_METHOD (cls);
        CLASS_METHOD (cls) = m;
        break;
      }
    case ATTRIBUTE_METHODCODE:
      {
        rc_opcode_t *code;
        u2 attribute_counts, RESERVED_SPACE;
        u4 code_length;
        RvMethod *m = (RvMethod *) arg;

        readu4 (ef, &code_length);
        code = (rc_opcode_t *) rc_malloc (code_length);
        readm (ef, code, code_length, 1);

        readu2 (ef, &RESERVED_SPACE);

        METHOD_OPLEN (m) = code_length;
        METHOD_OP (m) = code;

        readu2 (ef, &attribute_counts);
        for (i=0; i<attribute_counts; i++)
          {
            if (rc_read_attribute (r, (void *) m, ef))
              goto error;
          }
        break;
      }
    default:
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Invalid Attribute Type : 0x%x", attribute_type);
      return -1;
      /* not reach. */ 
      break;
    }

  return 0;

 error:
  return -1;
}

/**
    EF ü ̿Ͽ ϳ   мϿ д´.

   @param r     ROVM ü
   @param ef    struct efile ü.
 */
static RvClass *
rc_load_classfile_core (r, ef)
     struct rovm *r;
     struct efile *ef;
{
  int i;
  u2 fileformat_version, attribute_counts;
  u4 magic, made_time;
  RvClass *cls;
  
  readu4 (ef, &magic);
  if (magic != 0x0e0a0209)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Invalid Magic Number");
      return NULL_CLASS;
    }

  readu2 (ef, &fileformat_version);
  if (fileformat_version != 0x0001)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Only supports v0.1 file format version");
      return NULL_CLASS;
    }

  readu4 (ef, &made_time);

  cls = init_eclass ();

  readu2 (ef, &attribute_counts);
  for (i=0; i<attribute_counts; i++)
    {
      if (rc_read_attribute (r, cls, ef))
        {
          destroy_eclass (cls);
          return NULL_CLASS;
        }
    }

  return cls;
}

/**
   Class  PATH  о εϰ, ׿   Class ͸
   ȯϰ ˴ϴ.

    ε   ߻ , NULL_CLASS  ȯǰ ˴ϴ.

   @param r     ROVM ü
   @param path  ε带 ϰ   .  ̰ * * ̴.
 */
RvClass *
rc_load_classfile (r, path)
     struct rovm *r;
     char *path;
{
  RvClass *cls;
  struct efile *ef;

  if (!r || !path || (path && path[0] != '/'))
    return NULL_CLASS;

  ef = init_efile (r, path);
  if (!ef)
    return NULL_CLASS;

  cls = rc_load_classfile_core (r, ef);

  finish_efile (ef);

  return cls;
}
