#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

#include "class.h"
#include "file.h"

/**
   Class Tree  key  value  (PATH, CLS)  node  մϴ.

   @param r     ROVM ü
   @param path  Class  
   @param cls   ε Class 
   @return       ϵǾ , RC_SUCCESS  ȯϰ Ǹ,
                ׷  , -1  ȯϰ ˴ϴ.
*/
rc_status_t
rc_register_class (r, path, cls)
     struct rovm *r;
     char *path;
     RvClass *cls;
{
  if (!clstree_lookup (ROVM_CLSTREE (r), path))
    {
      char *dupstr = rc_strdup (path);

      /* Insert ̹Ƿ ̿  serialize ( )  ʿϴ.

         ???  tktree  clstree   mutex  Ͽ locking 
             ϰ ִµ, ̵   ٸ mutex  ϵ ִ
             ͵    .    ġ Ҵ 
             ʴ´.  */
      rc_thread_mutex_lock (ROVM_MUTEX (r));

      if (clstree_insert (ROVM_CLSTREE (r), dupstr, (void *) cls))
        {
          rc_thread_mutex_unlock (ROVM_MUTEX (r));
          return -1;
        }

      rc_thread_mutex_unlock (ROVM_MUTEX (r));
    }

  return RC_SUCCESS;
}

/**
   PATH  ϴ class   εϿ Class Tree  մϴ.

   @param r     ROVM ü
   @param path  ã Class 
   @return       εϿ , ش Class ͸ ׷  ,
                NULL_CLASS  ȯմϴ.
*/
RvClass *
rc_load_class (r, path)
     struct rovm *r;
     char *path;
{
  rc_status_t rv;
  RvClass *cls;

  if (!r || !path)
    return NULL_CLASS;

  cls = rc_load_classfile (r, path);
  if (!cls)
    return NULL_CLASS;

  rv = rc_register_class (r, path, cls);
  if (rv != RC_SUCCESS)
    return NULL_CLASS;

  return cls;
}

/**
   ü R  ϴ Class Tree  PATH  شϴ Class  ã, ׿
   ´ RvClass ü ȯմϴ.

    Class Tree  ش Class  ã Ͽٸ, ش path   
   loading  ϰ ˴ϴ.

   @param r     ROVM ü
   @param path  ã Class 
   @return      ش Class  ã εǾٸ ش Ŭ ͸ ȯմϴ.
                ׷  , NULL_CLASS  ȯմϴ.
 */
RvClass *
rc_lookup_class (r, path)
     struct rovm *r;
     char *path;
{
  RvClass *cls;

  if (!r || !path)
    return NULL_CLASS;

  cls = (RvClass *) clstree_lookup (ROVM_CLSTREE (r), path);
  if (cls)
    return cls;

  return rc_load_class (r, path);
}

/**
   IPTYPE  HOSTNAME, PORT, PATH  ̿Ͽ ׿  class  
   ´.   HOSTNAME   ӽ IP (Ȥ hostname)  ,
    ش class  εϿ ׿   ȯѴ.

   @param r             request_rec ü
   @param iptype        IPv4  IPv6  Ų.  IPv6   
                         ʴ´.
   @param hostname      Host ̸
   @param port          Host Ʈ ȣ
   @param path          ãϴ class .
   @return               class    , NULL_CLASS 
                        ȯϰ,  ٸ host  û  , 
                        REMOTE_CLASS  ȯѴ.  ׷   load 
                        class  Ͱ ȯѴ.
*/
RvClass *
rc_getclassbyhost (r, iptype, hostname, port, path)
     request_rec *r;
     int iptype;
     char *hostname, *path;
     unsigned short port;
{
  rc_status_t rv;
  rc_sockaddr_t *sa;

  rv = rv_sockaddr_info_get (&sa, hostname, RC_UNSPEC, port, 0, REQUEST_POOL (r));
  if (rv != RC_SUCCESS)
    return NULL_CLASS;

  if (!rc_sockaddr_equal (CONN_LOCAL_ADDR (REQUEST_CONN (r)), sa))
    return REMOTE_CLASS;

  return rc_lookup_class (REQUEST_ROVM (r), path);
}

/**
   RvObject ü Ӱ Ҵϸ, Local  Remote  κи
   մϴ.

   @return  ͸  · RvObject ü ͸ ȯմϴ.
 */
RvObject *
init_eobject (void)
{
  RvObject *o;

  o = (RvObject *) rc_malloc (sizeof (RvObject));
  if (!o)
    return NULL_OBJECT;

  OBJECT_CTIME (o) = rc_time_now ();

  return o;
}

/**
   Ŭ C   ObjectRef  Ͽ ȯմϴ.

   @param c     ObjectRef   Ŭ 
   @return       ObjectRef
 */
RvObject *
NewRvObject (c)
     RvClass *c;
{
  RvObject *o;

  o = init_eobject ();
  if (!o)
    return NULL_OBJECT;

  OBJECT_TYPE (o) = LOCAL_OBJECT;
  OBJECTL_CLASS (o) = c;

  return o;
}

/**
   ݿ ϴ Ŭ ؼ ObjectRef  Ͽ ȯմϴ.

   @param r             Request ü
   @param iptype        IPv4  IPv6  մϴ.
   @param hostname       Host Name
   @param port           Host  Ʈ ȣ
   @param path          Ŭ 
   @return              ݿ  ObjectRef    
                         ObjectRef
 */
RvObject *
NewRemoteRvObject (r, iptype, hostname, port, path)
     request_rec *r;
     int iptype;
     char *hostname, *path;
     unsigned short port;
{
  return NULL_OBJECT;
}
