/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_TICKET_H
#define _ROVM_TICKET_H

#include "core.h"

/**
   ⺻   slot  .
 */
#define DEFAULT_STACK_SLOT              256

#define TICKET_TIME(NODE)		((NODE)->tmade)

#define TICKET_SP(NODE)                 ((NODE)->sp)
#define TICKET_LOCAL(NODE)              ((NODE)->local)
#define TICKET_RET(NODE)                (&((NODE)->ret))

#define TICKET_STACK(NODE)              ((NODE)->stack)
#define TICKET_STACK_IDX(NODE, IDX)     ((NODE)->stack[(IDX)])
#define TICKET_MAX_STACK(NODE)          ((NODE)->max_stack)

/**
    request   , Ǵ üν, ڰ   
   µ  , ̸ ̿Ͽ  û     
   ֵ Ѵ.

    ü  ߿ üν  request     µ
    ִ.
 */
struct ticket
{
  /**
     Ticket   ð  ִ.  ̰ ߿  ð 
     ticket  , ڵ Ҹ ؼ ȴ.
  */
  rc_time_t tmade;

  /** Stack Pointer.  x86  stack pointer ̶ ϴ.  */
  rovm_stack_t *sp;
  /** Local Variable Pointer.  ̰ ڹ  ӽſ   
      Ʒ  `stack' 迭 ϳ slot  Ű ȴ.  ̿  ڼ
       `Stack  Local  '  ϱ ٶ.

      @note  `Stack  Local  '   ʴ´.  */
  rovm_stack_t *local;

  /** Ticket  ϴ  slot .   迭Դϴ. */
  rovm_stack_t *stack;
  /**   `stack'  Ҵ  slot  .  */
  int max_stack;

  /**  ticket operation  óǸ鼭 ȯϰ Ǵ return  Ǵ
      ġ.  */
  rovm_stack_t ret;
};

extern char *create_ticketid (request_rec *);
extern int gen_unique_ticketid (char *);
extern int register_ticketid (request_rec *, char *);
extern struct ticket *lookup_ticket (request_rec *, char *);
extern int ticket_pre_config ( struct ticket *);
extern void destroy_ticket (struct ticket *);
extern int destroy_tickets (request_rec *, char *);

#endif
