/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"

/*   thread   wrapper  Ǿ ֽϴ.  */

/**
   Thread  ϳ Ѵ.

   @param new	 Thread  pointer.
   @param attr	 Thread  Attribute.
   @param func	 function.
   @param data	 data.
   @param pool	Thread  ʿ ޸𸮸 Ҵ ޸ pool
 */
rc_status_t rc_thread_create (rc_thread_t **new,
			      rc_threadattr_t *attr,
			      rc_thread_start_t func,
			      void *data,
			      rc_pool_t *pool)
{
  return apr_thread_create (new, attr, func, data, pool);
}

/**
   ڽ thread  join   ٸ.

   @param rv	thread ü exitval  ȯȴ.
   @param thd	Thread  pointer.
 */
rc_status_t rc_thread_join (rc_status_t *rv,
			    rc_thread_t *thd)
{
  return apr_thread_join (rv, thd);
}

/**
   Thread  attribute  Ѵ.

   @param new	 thread attribute
   @param pool	ü Ҵ  ޸ pool
 */
rc_status_t rc_threadattr_create (rc_threadattr_t **new,
				  rc_pool_t *pool)
{
  return apr_threadattr_create (new, pool);
}

/**
   Thread attribute  Ѵ.

   @param attr	Thread attribute
   @param on	Flags
 */
rc_status_t rc_threadattr_detach_set (rc_threadattr_t *attr,
				      rc_int32_t on)
{
  return apr_threadattr_detach_set (attr, on);
}

/**
    thread  Ѵ.

   @param thd	 thread
   @param rv	̸  thread  ȯϴ ȯ.
*/
rc_status_t rc_thread_exit (rc_thread_t *thd,
			    rc_status_t rv)
{
  return apr_thread_exit (thd, rv);
}

/**
   Thread  rc type κ os specific type  ȯѴ.

   @param ot	ȯ rc thread
   @param rt	츮 ȯ os specific thread
 */
rc_status_t rc_os_thread_get (rc_os_thread_t **ot,
			      rc_thread_t *rt)
{
  return apr_os_thread_get (ot, rt);
}
