/// @file ShowBoard.h
#ifndef SHOWBOARD_H
#define SHOWBOARD_H

#include "../core/process/Actor.h"
/**
	@brief Sprite  Ŭ

	2D Ʈ   ִ üԴϴ.\n
*/
class ShowBoard : public Actor {
public:
	ShowBoard(){}
	virtual ~ShowBoard(){}
	static Actor* makeShowBoard(TiXmlElement* _pShowBoardElement){
		ShowBoard* pShowBoard = new ShowBoard;
		int x, y, l, r, t, b;
		_pShowBoardElement->Attribute("x", &x);
		_pShowBoardElement->Attribute("y", &y);
		_pShowBoardElement->Attribute("l", &l);
		_pShowBoardElement->Attribute("r", &r);
		_pShowBoardElement->Attribute("t", &t);
		_pShowBoardElement->Attribute("b", &b);

		pShowBoard->aRect_.left = l;
		pShowBoard->aRect_.right = r;
		pShowBoard->aRect_.top = t;
		pShowBoard->aRect_.bottom = b;
		pShowBoard->fX = x;
		pShowBoard->fY = y;

		//Rendering OffSet
		pShowBoard->fXRenderOffSet_ = (float(l-r))/2; // = -(r-l)
		pShowBoard->fYRenderOffSet_ = (float(b-t))/2;
		
		return (Actor*)pShowBoard;
	}
	void process(){
	}
	void setRObject(DevicePocket* _pDevicePocket, ControlTable* _pControlTable){
		pD3DDevice_ = _pDevicePocket->aCoreGraphic.getD3DDevice();
		pSprite_ = _pDevicePocket->aCoreGraphic.getSprite();
		pControlTable = _pControlTable;

		D3DXMatrixRotationZ(&matRotZ_, D3DX_PI);
		D3DXMatrixScaling(&matScale_, 0.55f, 0.55f, 1.0f);
	}
	void draw(Model* _pModel){
		if(bShow){
			//ǥ ݴ
			D3DXMatrixTranslation(&matTrans_, fX+fXRenderOffSet_, -fY-fYRenderOffSet_, 10.0f);
			matWorld = matTrans_ * matScale_ * matRotZ_;
			//pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld_);
			pSprite_->SetTransform(&matWorld);
			pSprite_->Draw(_pModel->pTexture, &aRect_, NULL, NULL, D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,fOpacity));
		}
	}
private:
	LPDIRECT3DDEVICE9 pD3DDevice_;
	LPD3DXSPRITE      pSprite_;
	RECT              aRect_;
	float fXRenderOffSet_;
	float fYRenderOffSet_;

	D3DXMATRIXA16 matTrans_;
	D3DXMATRIXA16 matScale_;
	D3DXMATRIXA16 matRotZ_;
};
#endif