/// @file RenderEffector.h
#ifndef RENDEREFFECTOR_H
#define RENDEREFFECTOR_H
/**
	@brief  Ʈ Ŭ

	ÿ  Ʈ ϴ ŬԴϴ.\n
	 flat Mask Fade in-out ȿ մϴ.\n
	RenderManager  ӵǾ  ȿ ϸ  и Դϴ.
*/
class RenderEffector {
public:
	RenderEffector() : pMaskVB_(NULL) {}
	~RenderEffector(){
		if(pMaskVB_ != NULL){pMaskVB_->Release(); pMaskVB_ = NULL;}
	}
	void initRenderEffector(LPDIRECT3DDEVICE9 _pD3DDevice){
		pD3DDevice_ = _pD3DDevice;
		EffectVertex aFadeMask[] = {
			//Top Face
			{-400.0f,  300.0f, 0.0f, D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,1.0f)}, //Vertex 0
			{ 400.0f,  300.0f, 0.0f, D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,1.0f)}, //Vertex 1
			{-400.0f, -300.0f, 0.0f, D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,1.0f)}, //Vertex 2
			{ 400.0f, -300.0f, 0.0f, D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,1.0f)}  //Vertex 3
		};
		pD3DDevice_->CreateVertexBuffer(sizeof(aFadeMask),D3DUSAGE_DYNAMIC | D3DUSAGE_WRITEONLY,EffectVertex::FVF_FLAG,D3DPOOL_DEFAULT,&pMaskVB_,NULL);
		void* pData = NULL;
		pMaskVB_->Lock(0,sizeof(aFadeMask),(void**)&pData,0);
		memcpy(pData,aFadeMask,sizeof(aFadeMask));
		pMaskVB_->Unlock();
		D3DXMatrixTranslation(&matWorld_, 0, 0, 10.0f);
	}
	void drawFadeMask(const float& _refRate){
		EffectVertex* pEffectVertexData = NULL;
		for(int offSet = 0; offSet < 4; offSet++){
			pMaskVB_->Lock( offSet * sizeof(EffectVertex), // Offset to lock
							sizeof(EffectVertex),    // Size to lock
							(void**) &pEffectVertexData, 0);
			pEffectVertexData->dColor = D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,_refRate);
			pMaskVB_->Unlock();
		}
		pD3DDevice_->SetStreamSource( 0, pMaskVB_, 0, sizeof(EffectVertex) );
		pD3DDevice_->SetFVF( EffectVertex::FVF_FLAG );
		pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld_);
		pD3DDevice_->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );
	}

private:
	LPDIRECT3DVERTEXBUFFER9 pMaskVB_;
	LPDIRECT3DDEVICE9       pD3DDevice_;
	D3DXMATRIXA16           matWorld_;
};
#endif