/// @file Indicator.h
#ifndef INDICATOR_H
#define INDICATOR_H

#include "../core/process/Actor.h"
#include <windows.h>
#pragma comment(lib, "winmm.lib")

/// @brief rotation ɰ drawing  3Dü
class Indicator : public Actor {
public:
	static void cmdRotate(Actor* _pRObject){
		//Indicator* pIndicator = dynamic_cast< Indicator * >(_pRObject);
		Indicator* pIndicator = (Indicator*)(_pRObject);
		pIndicator->bRotation = true;
	}
public:
	Indicator() : bRotation(false) {}
	virtual ~Indicator(){}
	static Actor* makeIndicator(TiXmlElement* _pIndicatorElement){
		Indicator* pIndicator = new Indicator;
		int x, y;
		_pIndicatorElement->Attribute("x", &x);
		pIndicator->fX = x;
		_pIndicatorElement->Attribute("y", &y);
		pIndicator->fY = y;
		return (Actor*)pIndicator;
	}
	void process(){
		if(bRotation){
			rotation_();
		}else{
			D3DXMatrixTranslation(&matWorld, -fX, fY, -80.0f);
		}
	}
	void draw(Model* _pModel){
		if(bShow){
            pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld );
			pD3DDevice_->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,_pModel->numVertices,0,_pModel->numPolygons);
		}
	}
	void setRObject(DevicePocket* _pDevicePocket, ControlTable* _pControlTable){
		pD3DDevice_ = _pDevicePocket->aCoreGraphic.getD3DDevice();
	}
public:
	bool bRotation;

private:
	LPDIRECT3DDEVICE9     pD3DDevice_;
	float fAngle_;
	D3DXMATRIXA16 matRotX_;
	D3DXMATRIXA16 matRotY_;
	D3DXMATRIXA16 matRotZ_;
	D3DXMATRIXA16 matTrans_;
	void rotation_(){
		fAngle_ = ((timeGetTime())*(2.0f * D3DX_PI))/(1000.0f * 10);
		D3DXMatrixTranslation(&matTrans_, -fX, fY, -80.0f);
		D3DXMatrixRotationX(&matRotX_, fAngle_);
		D3DXMatrixRotationY(&matRotY_, fAngle_);
		D3DXMatrixRotationZ(&matRotZ_, fAngle_);
		matWorld = matRotX_ * matRotY_ * matRotZ_ * matTrans_;
	}
};
#endif