/// @file PrintBoard.h
#ifndef PRINTBOARD_H
#define PRINTBOARD_H

#include "../core/process/RObject.h"
#include <string>
using std::string;

/**
	@brief   ü

	script print oper ȭ鿡 ڸ   ִ üԴϴ.\n
	Ű Է    ֽϴ.
*/
class PrintBoard : public RObject {
	public:
		PrintBoard() :
			aColor_(D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,0.5f)),
			state_(ONLY_SHOW_STATE),wpIndex_(0){}
		virtual ~PrintBoard(){}
		static RObject* makePrintBoard(TiXmlElement* _pPrintBoardElement){
			PrintBoard* pPrintBoard = new PrintBoard;
			int x, y, l, r, t, b;
			_pPrintBoardElement->Attribute("x", &x);
			_pPrintBoardElement->Attribute("y", &y);
			_pPrintBoardElement->Attribute("l", &l);
			_pPrintBoardElement->Attribute("r", &r);
			_pPrintBoardElement->Attribute("t", &t);
			_pPrintBoardElement->Attribute("b", &b);

			pPrintBoard->aRect_.left = l;
			pPrintBoard->aFontRect_.left = l+15;
			pPrintBoard->aRect_.right = r;
			pPrintBoard->aFontRect_.right = r-15;
			pPrintBoard->aRect_.top = t;
			pPrintBoard->aFontRect_.top = t+20;
			pPrintBoard->aRect_.bottom = b;
			pPrintBoard->aFontRect_.bottom = b-20;
			
			pPrintBoard->fX = x - (float(r-l))/2;
			pPrintBoard->fY = y + (float(b-t))/2;

			return (RObject*)pPrintBoard;
		}
		void process(){
			if(state_ == INPUT_STATE){
				if(pCoreInput_->clickedKey(DIK_C)){
					if(wpIndex_ < wpNum_){
						wpIndex_ ++;
					}else if(wpIndex_ == wpNum_){
						pControlTable_->controlType = COMMAND;
					}
				}
			}
		}
		void setRObject(CoreGraphic* _pCoreGraphic, CoreInput* _pCoreInput, OggPlayer* _pCoreSound, ControlTable* _pControlTable){
			pD3DDevice_ = _pCoreGraphic->getD3DDevice();
			pSprite_ = _pCoreGraphic->getSprite();
			pFont_ = _pCoreGraphic->getFont(0);

			pCoreInput_ = _pCoreInput;
			pControlTable_ = _pControlTable;

			D3DXMATRIXA16 matTrans, matScale, matRotZ;
			D3DXMatrixRotationZ(&matRotZ, D3DX_PI);
			D3DXMatrixScaling(&matScale, 1.0f, 1.0f, 1.0f);
			D3DXMatrixTranslation(&matTrans, fX, -fY, 10.0f);
			//ǥ ݴ
			matWorld_ = matTrans * matScale * matRotZ;
		}
		void draw(Model* _pModel){
			if(bShow){
				pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld_);
				pSprite_->Draw(_pModel->pTexture, &aRect_, NULL, NULL, aColor_);
				RECT aTempFontRect = {aFontRect_.left, aFontRect_.top, aFontRect_.right, aFontRect_.bottom};
				int line = 0;
				if(aWaitPoint.empty()){
					for(pStringItr_ = aStringPocket.begin();pStringItr_ != aStringPocket.end(); pStringItr_++){
						pFont_->DrawText(pSprite_,pStringItr_->c_str(),-1,&aTempFontRect,DT_NOCLIP,0xffffffff);
						aTempFontRect.top += 18;
					}
				}else{
					for(pStringItr_ = aStringPocket.begin();
						pStringItr_ != aStringPocket.end()  && line < aWaitPoint[wpIndex_]; pStringItr_++, line++){
						pFont_->DrawText(pSprite_,pStringItr_->c_str(),-1,&aTempFontRect,DT_NOCLIP,0xffffffff);
						aTempFontRect.top += 18;
					}
				}
			}
		}
		void setWait(){state_ = INPUT_STATE;
		wpNum_ = aWaitPoint.size();
		return;
		}
		vector<string> aStringPocket;
		vector<int>    aWaitPoint;
	private:
		enum{ INPUT_STATE = 0, ONLY_SHOW_STATE};
		int state_;
		int wpIndex_;
		int wpNum_;
		D3DCOLOR      aColor_;
		RECT          aRect_;
		RECT          aFontRect_;

		LPDIRECT3DDEVICE9     pD3DDevice_;
		LPD3DXSPRITE          pSprite_;
		LPD3DXFONT            pFont_;

		CoreInput* pCoreInput_;
		vector<string>::iterator pStringItr_;
};
#endif