/// @file RenderPocket.h
#ifndef RENDERPOCKET_H
#define RENDERPOCKET_H
#include "RenderQueue.h"

/**
	@brief GameCore  μ Ŭ

	 ȿ ϱ ŬԴϴ.\n
	Model  Sprit ΰ ü Ͽ մϴ.
*/

class RenderPocket {
	public:
		vector<RenderQueue*> sortedModelObjectQueue;
		vector<RenderQueue*> sortedSpriteObjectQueue;

	public:
		LPDIRECT3DDEVICE9 getD3DDevice(){return pD3DDevice_;}
		void              setD3DDevice(LPDIRECT3DDEVICE9 _pD3DDevice){pD3DDevice_ = _pD3DDevice;}
		void              setSprite(LPD3DXSPRITE _pSprite){pSprite_ = _pSprite;}
		void render(){
			renderModelQueue_();
			renderSpriteQueue_();
		}

	private:
		vector<RenderQueue*>::iterator pItrRenderQueue_;
		vector<RObject*>::iterator     pItrRObject_;
		RenderQueue* pRenderQueue_;
		RObject*     pRObject_;

		LPDIRECT3DDEVICE9 pD3DDevice_;
		LPD3DXSPRITE      pSprite_;
		Model*            pModel_;

		void renderModelQueue_(){
			pD3DDevice_->SetFVF(D3DFVF_CustomVertex);
			pD3DDevice_->SetRenderState( D3DRS_LIGHTING, false);
			for(pItrRenderQueue_=sortedModelObjectQueue.begin(); pItrRenderQueue_ != sortedModelObjectQueue.end(); pItrRenderQueue_++){
				pRenderQueue_ = *pItrRenderQueue_;
				pModel_ = pRenderQueue_->pModel;
				if(pModel_->pTexture){
					pD3DDevice_->SetTexture(0,pModel_->pTexture);
				}
				//todo : need to refactoring setstreamsource
				pD3DDevice_->SetStreamSource(0, pRenderQueue_->pModel->pVB,0,sizeof(CustomVertex));
				if(pModel_->pIB){
					pD3DDevice_->SetIndices(pModel_->pIB);
				}
				for(pItrRObject_=pRenderQueue_->vectorRObject.begin();
					pItrRObject_ != pRenderQueue_->vectorRObject.end(); pItrRObject_++){					
					pRObject_ = *pItrRObject_;
					pRObject_->draw(pModel_);
				}
			}
		}
		void renderSpriteQueue_(){
			//pD3DDevice_->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
			//pD3DDevice_->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

			pSprite_->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_OBJECTSPACE );
			for(pItrRenderQueue_=sortedSpriteObjectQueue.begin(); pItrRenderQueue_ != sortedSpriteObjectQueue.end(); pItrRenderQueue_++){
				pRenderQueue_ = *pItrRenderQueue_;
				pModel_ = pRenderQueue_->pModel;
				for(pItrRObject_=pRenderQueue_->vectorRObject.begin();
					pItrRObject_ != pRenderQueue_->vectorRObject.end(); pItrRObject_++){					
					pRObject_ = *pItrRObject_;
					pRObject_->draw(pModel_);
				}
			}
			pSprite_->End();
		}
};
#endif