/// @file CoreGraphic.h
#ifndef COREGRAPHIC_H
#define COREGRAPHIC_H

#include "Model.h"
#include <time.h>
#include <stdio.h>

/**
	@brief Direct3D ġŬ

	D3D õ ü ϴ ġŬԴϴ.\n
	ÿ ؽĿ ؽ۸  Model Ŭ ̿մϴ.\n
	⺻ camera 2 Ʈ, Ʈü, ׸ showFPS Լ ϴ.\n
	   淮ȭ Ǿ,  μ GameCore Ѱϴ.\n
	GameCore  Ʈ Ҷ ҰԴϴ.
*/
class CoreGraphic {
	public:
		CoreGraphic() :
			vEyePt_( 0.0f, 0.0f, 400.0f ),
			vLookatPt_( 0.0f, 0.0f, 0.0f ),
			vUpVec_( 0.0f, 1.0f, 0.0f ){
			pD3D_       = NULL;
			pD3DDevice_ = NULL;
			pSprite_    = NULL;
			pFpsFont_   = NULL;
			pFont00_    = NULL;
			pFont01_    = NULL;
			//pFont02_    = NULL;

			aFpsFontPosition_.left   = 10;
			aFpsFontPosition_.top    = 10;
			aFpsFontPosition_.right  = 150;
			aFpsFontPosition_.bottom = 90;
		}
		~CoreGraphic(){
			if(pD3DDevice_ != NULL){ pD3DDevice_->Release(); pD3DDevice_ = NULL;}
			if(pD3D_ != NULL){ pD3D_->Release(); pD3D_ = NULL;}
			if(pSprite_ != NULL){ pSprite_->Release(); pSprite_ = NULL;}
			if(pFpsFont_ != NULL){ pFpsFont_->Release(); pFpsFont_ = NULL;}
			if(pFont00_ != NULL){ pFont00_->Release(); pFont00_ = NULL;}
			if(pFont01_ != NULL){ pFont01_->Release(); pFont01_ = NULL;}
		}

		void initD3D(const HWND _hWnd, const int _width, const int _height, const bool _windowed);
		void camera(const float _fX, const float _fY, const float _fZ);
		void showFPS();
		void setModel(Model* _pModel);
		void draw(Model* _pModel);

		LPDIRECT3DDEVICE9 getD3DDevice(){return pD3DDevice_;}
		LPD3DXSPRITE      getSprite(){return pSprite_;}
		LPD3DXFONT        getFont(int _fontType){
			LPD3DXFONT pFont;
			switch(_fontType){
				case 0  : pFont = pFont00_; break;
				case 1  : pFont = pFont01_; break;
				default : pFont = NULL;     break;
			}
			return pFont;
		}
	private:
		LPDIRECT3D9           pD3D_;
		LPDIRECT3DDEVICE9     pD3DDevice_;
		LPD3DXSPRITE          pSprite_;
		LPD3DXFONT            pFont00_;
		LPD3DXFONT            pFont01_;
		//LPD3DXFONT            pFont02_;

		D3DPRESENT_PARAMETERS aD3Dpp_;
		D3DDISPLAYMODE        aD3Ddm_;
		float                 monitorRatio_;

		D3DXMATRIXA16         matView_;
		D3DXMATRIXA16         matProj_;
		D3DXVECTOR3           vEyePt_;
		D3DXVECTOR3           vLookatPt_;
		D3DXVECTOR3           vUpVec_;

		LPD3DXFONT            pFpsFont_;
		RECT                  aFpsFontPosition_;
		DWORD                 frameCount_;
		DWORD                 startTime_;
		char                  strFPS_[20];
};

#endif