/// @file CoreGraphic.cpp
#include "CoreGraphic.h"

/**
	@brief MObjectSet Maker

	xmlϷκ Model, MObject  MObjectSet մϴ.\n
	MObjectSet  MObect, RMObject մϴ.

	@return MObjectSet*
*/

void CoreGraphic::initD3D(const HWND _hWnd, const int _width, const int _height, const bool _windowed){
	//construct D3D and set for D3DDevice
	if( NULL == ( pD3D_ = Direct3DCreate9( D3D_SDK_VERSION ) ) ){return;}
	pD3D_->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &aD3Ddm_ );
	ZeroMemory( &aD3Dpp_, sizeof(aD3Dpp_) );

	aD3Dpp_.Windowed = _windowed;
	//monitor ratio
	if (_windowed){monitorRatio_ = 1.333333f;}
	else{monitorRatio_ = (float)aD3Ddm_.Width/(float)aD3Ddm_.Height;}
	
	aD3Dpp_.SwapEffect = D3DSWAPEFFECT_DISCARD;
	aD3Dpp_.BackBufferFormat = aD3Ddm_.Format;
	aD3Dpp_.BackBufferWidth = _width;
	aD3Dpp_.BackBufferHeight = _height;
	aD3Dpp_.EnableAutoDepthStencil = TRUE;
	aD3Dpp_.AutoDepthStencilFormat = D3DFMT_D16;
	aD3Dpp_.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

	//construct D3DDevice
	if( FAILED( pD3D_->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _hWnd,
                                        D3DCREATE_SOFTWARE_VERTEXPROCESSING,
										&aD3Dpp_, &pD3DDevice_ ) ) ){return;}
}

void CoreGraphic::show(RMObject* _pRMObject){
	pD3DDevice_->SetTexture(0,_pRMObject->aModel.pTexture);
	pD3DDevice_->SetStreamSource(0,_pRMObject->aModel.pVB,0,sizeof(CustomVertex));
	pD3DDevice_->SetIndices(_pRMObject->aModel.pIB);
	D3DXMATRIXA16 matWorld;

	int numVertices = _pRMObject->aModel.numVertices;
	int numPolygons = _pRMObject->aModel.numPolygons;
	
	deque<MObject*>::iterator pItr;
	for(pItr=_pRMObject->dequeMObject.begin(); pItr != _pRMObject->dequeMObject.end(); pItr++){
		//list<MObject*>
		//so, *pItr = MObject* type, pItr = MObject**
		float x = (*pItr)->fX;
		float y = (*pItr)->fY;
		D3DXMatrixTranslation(&matWorld, -x, y, 0.0f);
		pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld );
		pD3DDevice_->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,
														numVertices,0, numPolygons);
	}
}

void CoreGraphic::camera(const float _fX, const float _fY, const float _fZ){
	//view matrix
	D3DXVECTOR3 vEyePt( 0.0f, 0.0f, 50.0f );
	D3DXVECTOR3 vLookatPt( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 vUpVec( 0.0f, 1.0f, 0.0f );
	D3DXMATRIXA16 matView;
	D3DXMatrixLookAtLH( &matView, &vEyePt, &vLookatPt, &vUpVec );
	pD3DDevice_->SetTransform( D3DTS_VIEW, &matView );

	//projection matrix
	D3DXMATRIXA16 matProj;
	D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, monitorRatio_, 1.0f, 100.0f );
	pD3DDevice_->SetTransform( D3DTS_PROJECTION, &matProj );
}
