/// @file GameCore.h
#ifndef GAMECORE_H
#define GAMECORE_H

#include "../core/graphic/CoreGraphic.h"
#include "../core/input/CoreInput.h"
#include "../core/sound/OggPlayer.h"
#include "../model/ModelMaker.h"
#include <vector>
using std::vector;

class GameCore {
	public:
		GameCore() : pCoreGraphic_(NULL), pCoreInput_(NULL), pCoreSound_(NULL) {}
		~GameCore(){
			vector<RMObject*>::iterator pRMObjectItr;
			for(pRMObjectItr=vectorRMObject_.begin(); pRMObjectItr != vectorRMObject_.end(); pRMObjectItr++){
				delete (*pRMObjectItr);
			}
			vector<MObject*>::iterator pMObjectItr;
			for(pMObjectItr=vectorMObject_.begin(); pMObjectItr != vectorMObject_.end(); pMObjectItr++){
				delete (*pMObjectItr);
			}
		}

		void initGame(CoreGraphic* _pCoreGraphic, CoreInput* _pCoreInput, OggPlayer* _pCoreSound){
			pCoreGraphic_ = _pCoreGraphic;
			pCoreInput_ = _pCoreInput;
			pCoreSound_ = _pCoreSound;

			pCoreGraphic_->getD3DDevice()->SetRenderState( D3DRS_LIGHTING, false);

			//𵨰 RMObject 
			Model aModel;
			ModelMaker::createCubeModel(pCoreGraphic_->getD3DDevice(), &aModel, "resource/game_resource/texture.png", 10);
			RMObject* pRMObject = new RMObject;
			pRMObject->aModel = aModel;
			vectorRMObject_.push_back(pRMObject);

			ModelMaker::createCubeModel(pCoreGraphic_->getD3DDevice(), &aModel, "resource/game_resource/texture2.png", 16);
			pRMObject = new RMObject;
			pRMObject->aModel = aModel;
			vectorRMObject_.push_back(pRMObject);

			//MObject 
			MObject* pMObject = new MObject;
			pMObject->bShow = true;
			pMObject->fX = 10;
			pMObject->fY = 10;
			pMObject->fZ = 10;
			pMObject->modelType = 0;
			vectorMObject_.push_back(pMObject);

			pMObject = new MObject;
			pMObject->bShow = true;
			pMObject->fX = 10;
			pMObject->fY = -10;
			pMObject->fZ = 10;
			pMObject->modelType = 0;
			vectorMObject_.push_back(pMObject);


			pMObject = new MObject;
			pMObject->bShow = true;
			pMObject->fX = -10;
			pMObject->fY = -10;
			pMObject->fZ = 10;
			pMObject->modelType = 1;
			vectorMObject_.push_back(pMObject);

			pMObject = new MObject;
			pMObject->bShow = true;
			pMObject->fX = -10;
			pMObject->fY = 10;
			pMObject->fZ = 10;
			pMObject->modelType = 1;
			vectorMObject_.push_back(pMObject);

			pCoreSound_->OpenOgg("resource/game_resource/london.ogg");
			pCoreSound_->Play(true);
		}

		/// @brief GameBaseRunnerſ Ǵ ӿ ٽԼ
		void run(){
			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message != WM_QUIT ){
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ){
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}else{
					if(pCoreInput_->listenKey(DIK_DOWN)){
						MessageBox(NULL, "Down Button", "Info", MB_OK | MB_ICONINFORMATION);
					}

					pCoreSound_->Update();
					vector<MObject*>::iterator pMObjectItr;

					for(pMObjectItr=vectorMObject_.begin(); pMObjectItr != vectorMObject_.end(); pMObjectItr++){
						if( (*pMObjectItr)->bShow ){
						vectorRMObject_[(*pMObjectItr)->modelType]->dequeMObject.push_back((*pMObjectItr));
						}
					}
					pCoreGraphic_->getD3DDevice()->Clear(0,NULL,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,D3DCOLOR_XRGB(100,100,100),1.0f,0);
					pCoreGraphic_->getD3DDevice()->BeginScene();
					pCoreGraphic_->camera(0, 0, 0);
					pCoreGraphic_->getD3DDevice()->SetFVF(D3DFVF_CustomVertex);
					vector<RMObject*>::iterator pRMObjectItr;
					for(pRMObjectItr=vectorRMObject_.begin(); pRMObjectItr != vectorRMObject_.end(); pRMObjectItr++){
						pCoreGraphic_->show((*pRMObjectItr));
						(*pRMObjectItr)->dequeMObject.clear();
					}
					pCoreGraphic_->getD3DDevice()->EndScene();
					pCoreGraphic_->getD3DDevice()->Present(NULL,NULL,NULL,NULL);
				}
			}
		}

	private:
		CoreGraphic* pCoreGraphic_;
		CoreInput* pCoreInput_;
		OggPlayer* pCoreSound_;

		vector<RMObject*> vectorRMObject_;
		vector<MObject*> vectorMObject_;
};

#endif