#ifndef GAMEBASE_H
#define GAMEBASE_H

#include "LayerInfo.h"

class GameBase {
	public:
		//set default
		GameBase(LayerInfo* _pLayerInfo){
			pLayerInfo_ = _pLayerInfo;

			pD3D_ = NULL;
			pD3DDevice_ = NULL;
		
			ZeroMemory( &paramD3D_, sizeof(paramD3D_) );
			paramD3D_.Windowed = TRUE;
			paramD3D_.SwapEffect = D3DSWAPEFFECT_DISCARD;
			paramD3D_.BackBufferFormat = D3DFMT_UNKNOWN;
			paramD3D_.EnableAutoDepthStencil = TRUE;
			paramD3D_.AutoDepthStencilFormat = D3DFMT_D16;
			paramD3D_.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

		}
		~GameBase(){}

		//set d3d device
		void setParamD3D(){}
		
		//new and delete gamedevice
		 void newGameDevice(){
			if( NULL == ( pD3D_ = Direct3DCreate9( D3D_SDK_VERSION ) ) ){return;}
			if( FAILED( pD3D_->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, pLayerInfo_->hWnd,
                                             D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                                             &paramD3D_, &pD3DDevice_ ) ) ){return;}
			pLayerInfo_->pD3DDevice = pD3DDevice_;

			if(FAILED(DirectInput8Create(GetModuleHandle(NULL),DIRECTINPUT_VERSION,
				                         IID_IDirectInput8,(void**)&pDInPut_,NULL))){return;}

			if(FAILED(pDInPut_->CreateDevice(GUID_SysKeyboard,&pDIDeviceKB_,NULL))){return;}
			if(FAILED(pDIDeviceKB_->SetDataFormat(&c_dfDIKeyboard))){return;}
			if(FAILED(pDIDeviceKB_->SetCooperativeLevel(pLayerInfo_->hWnd,DISCL_BACKGROUND | DISCL_NONEXCLUSIVE))){return;}
			if(FAILED(pDIDeviceKB_->Acquire())){return;}
			pLayerInfo_->pDIDeviceKB = pDIDeviceKB_;

			if(FAILED(pDInPut_->CreateDevice(GUID_SysMouse,&pDIDeviceMouse_,NULL))){return;}
			if(FAILED(pDIDeviceMouse_->SetDataFormat(&c_dfDIMouse))){return;}
			if(FAILED(pDIDeviceMouse_->SetCooperativeLevel(pLayerInfo_->hWnd,DISCL_BACKGROUND | DISCL_NONEXCLUSIVE))){return;}
			if(FAILED(pDIDeviceMouse_->Acquire())){return;}
			pLayerInfo_->pDIDeviceMouse = pDIDeviceMouse_;
		}

		void deleteGameDevice(){

			if(pD3DDevice_ != NULL){ pD3DDevice_->Release(); pD3DDevice_ = NULL;}
			if(pD3D_ != NULL){ pD3D_->Release(); pD3D_ = NULL;}

			if(pDIDeviceMouse_ != NULL){ pDIDeviceMouse_->Release(); pDIDeviceMouse_ = NULL;}
			if(pDIDeviceKB_ != NULL){ pDIDeviceKB_->Release(); pDIDeviceKB_ = NULL;}
			if(pDInPut_ != NULL){ pDInPut_->Release(); pDInPut_ = NULL;}
		}

		//default run
		void run(){
			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message != WM_QUIT ){
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ){
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}else{
				}
			}
		}

	private:
		GameBase(){}

		LPDIRECT3D9        pD3D_;
		LPDIRECT3DDEVICE9  pD3DDevice_;

		LPDIRECTINPUT8        pDInPut_;
		LPDIRECTINPUTDEVICE8  pDIDeviceKB_;
		LPDIRECTINPUTDEVICE8  pDIDeviceMouse_;

		D3DPRESENT_PARAMETERS paramD3D_;
		LayerInfo* pLayerInfo_;
};

#endif