#ifndef GAMEOBJECT_H
#define GAMEOBJECT_H

#include "../object/ObjectManager.h"

//for FVF
#define D3DFVF_CustomVertex	( D3DFVF_XYZ | D3DFVF_TEX1 )

class ObjectManager {
	public:
		ObjectManager(LayerInfo* _pLayerInfo){
			pLayerInfo_ = _pLayerInfo;
		}
		~ObjectManager(){
			delete pMObjectSet;
		}
		
		//depend on "StateInfo" and script that may be confined Milestone3
		void createObjectPool(){
			pMObjectSet = new MObjectSet;
			aModel.pD3DDevice = pLayerInfo_->pD3DDevice;
			ModelMaker::createCubeModel(&aModel, "game_resource/texture.png", 2);
			pMObjectSet->aModel = aModel;
		}

		void createObject(){
			aMObject.fX = 0;
			aMObject.fY = 0;
			aMObject.fZ = 0;
			aMObject.bShow = TRUE;
		}

		void show(){
			pMObjectSet->pMObject = &aMObject;
			MObjectManager::camera(pLayerInfo_, 1, 1, 1);
			pLayerInfo_->pD3DDevice->SetFVF(D3DFVF_CustomVertex);
			MObjectManager::show(pMObjectSet, 1);
		}
		void loadTexture();
		void createCubePolygon();

		//ToDo
		void cache(){}

	private:
		LayerInfo* pLayerInfo_;
		MObject aMObject;
		Model aModel;
		MObjectSet* pMObjectSet;
};

#endif