#include "ObjectManager.h"

void ObjectManager::show(LayerInfo* _pLayerInfo, RenderMObject* _pRenderMObject){
	_pLayerInfo->pD3DDevice->SetTexture(0,_pRenderMObject->aModel.pTexture);
	_pLayerInfo->pD3DDevice->SetStreamSource(0,_pRenderMObject->aModel.pVB,0,sizeof(CustomVertex));
	_pLayerInfo->pD3DDevice->SetIndices(_pRenderMObject->aModel.pIB);
	D3DXMATRIXA16 matWorld;

	int numVertices = _pRenderMObject->aModel.numVertices;
	int numPolygons = _pRenderMObject->aModel.numPolygons;
	
	list<MObject*>::iterator pItr;
	for(pItr=_pRenderMObject->listMObject.begin(); pItr != _pRenderMObject->listMObject.end(); pItr++){
		//list<MObject*>
		//so, *pItr = MObject* type
		float x = (*pItr)->fX;
		float y = (*pItr)->fY;
		D3DXMatrixTranslation(&matWorld, -x, y, 0.0f);
		_pLayerInfo->pD3DDevice->SetTransform( D3DTS_WORLD, &matWorld );
		_pLayerInfo->pD3DDevice->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,
														numVertices,0, numPolygons);
	}
}

void ObjectManager::camera(LayerInfo* _pLayerInfo, float _fX, float _fY, float _fZ){
	//view matrix
	D3DXVECTOR3 vEyePt( 0.0f, 0.0f, 50.0f );
	D3DXVECTOR3 vLookatPt( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 vUpVec( 0.0f, 1.0f, 0.0f );
	D3DXMATRIXA16 matView;
	D3DXMatrixLookAtLH( &matView, &vEyePt, &vLookatPt, &vUpVec );
	_pLayerInfo->pD3DDevice->SetTransform( D3DTS_VIEW, &matView );

	//projection matrix
	D3DXMATRIXA16 matProj;
	D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, _pLayerInfo->monitorRatio, 1.0f, 100.0f );
	_pLayerInfo->pD3DDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}