/// @file ObjectManager.h
#ifndef MOBJECTMANAGER_H
#define MOBJECTMANAGER_H

#include "../model/ModelMaker.h"
#include "../xml/tinyxml.h"
#include "Indicator.h"
#include <list>

using namespace std;

//  Ѵٸ enum .
/*enum {
	INDICATOR = 0
};*/

/**
	@brief   ӿƮ 

	 ȿ ϱ ŬԴϴ.\n
	 ʿ  ϸ,  MObject List· մϴ.\n
	RenderMObjectп MObject Model  ʰ  Ÿ  ˴ϴ.\n
	RenderMObject νϽ ObjectManager::load Ǹ,  MObjectSet ˴ϴ.
*/
class RenderMObject {
	public:
		RenderMObject(){
			aModel.pVB = NULL;
			aModel.pIB = NULL;
			aModel.pTexture = NULL;
		}
		~RenderMObject(){
			if(aModel.pVB != NULL){aModel.pVB->Release(); aModel.pVB = NULL;}
			if(aModel.pIB != NULL){aModel.pIB->Release();  aModel.pIB = NULL;}
			if(aModel.pTexture != NULL){aModel.pTexture->Release(); aModel.pTexture=NULL;}
		}
		Model aModel;
		list<MObject *> listMObject;
};

/**
	@brief MObject  RenderMObject 

	MObject Ŭ߿   ū ŬԴϴ.\n
	  ִ RenderMObject MObjectŬ ӹ Ŭ  մϴ.\n
	  MObject  RenderObject   մϴ.\n
	MObject ڽŬ ߰ߴٸ,  MObjectSet ߰մϴ.\n
	 ObjectManager::load Ǹ Ҹ  Ŭ մϴ.
*/
class MObjectSet {
	public:
		MObjectSet(){
			pRenderMObject = NULL;
			pIndicator = NULL;
		}
		~MObjectSet(){
			if(pRenderMObject != NULL){delete[] pRenderMObject; pRenderMObject = NULL;}
			if(pIndicator != NULL){delete[] pIndicator; pIndicator = NULL;}
		}

		int numRenderMObject;
		RenderMObject* pRenderMObject;
		//enable to add MObjectType
		int numIndicator;
		Indicator* pIndicator;
};

/**
	@brief Ʈ  Ŭ

	Ʈ ϴ static Լ ŬԴϴ.\n
	 Ʈ  MObject(  Ʈ) մϴ.
*/
class ObjectManager {
	public:
		static MObjectSet* load(LayerInfo* _pLayerInfo, TiXmlNode* _pSceneNode);
		static void camera(LayerInfo* _pLayerInfo, float _fX, float _fY, float _fZ);
		static void show(LayerInfo* _pLayerInfo, RenderMObject* _pRenderMObject);
};
#endif