/// @file ObjectLoader.cpp
#include "ObjectManager.h"

/**
	@brief MObjectSet Maker

	xmlϷκ Model, MObject  MObjectSet մϴ.\n
	MObjectSet  MObect, RenderMObject մϴ.

	@return MObjectSet*
*/
MObjectSet* ObjectManager::load(LayerInfo* _pLayerInfo, TiXmlNode* _pSceneNode){

	TiXmlNode* pModelNode = _pSceneNode->FirstChild("Model");
	assert(pModelNode); //exception code

	//MObjectSet
	MObjectSet* pMObjectSet = new MObjectSet;
	
	//creating RenderMObject (array)
	//RenderMObject has a Model and a MObjectList to render
	//so, RenderMObject nums equar Model nums
	pModelNode->ToElement()->Attribute("totalNum", &(pMObjectSet->numRenderMObject));
	RenderMObject* pRenderMObject = new RenderMObject[pMObjectSet->numRenderMObject];
	TiXmlElement* pModelList = pModelNode->FirstChildElement();
	for(int a=0; pModelList; a++){
		if(strcmp(pModelList->Attribute("type"), "cube") == 0){
			const char *pTextureName = pModelList->Attribute("texture");
			int scale; pModelList->Attribute("scale", &scale);
			Model aModel;
			ModelMaker::createCubeModel(_pLayerInfo->pD3DDevice, &aModel, pTextureName, scale);
			pRenderMObject[a].aModel = aModel;
		}
		pModelList = pModelList->NextSiblingElement();
	}
	//adding RenderMObjectInof to MObjectSet
	pMObjectSet->pRenderMObject = pRenderMObject;


	//creating MObject (array)
	TiXmlNode* pMObjectNode = _pSceneNode->FirstChild("MObject");
	assert(pMObjectNode);
	
	//creating indicator
	Indicator* pIndicator = NULL;
	TiXmlNode* pIndicatorNode = pMObjectNode->FirstChild("Indicator");
	if(pIndicatorNode){
		pIndicatorNode->ToElement()->Attribute("totalNum", &(pMObjectSet->numIndicator));
		pIndicator = new Indicator[pMObjectSet->numIndicator];
		TiXmlElement* pIndicatorList = pIndicatorNode->FirstChildElement();
		for(int a=0; pIndicatorList; a++){
			pIndicatorList->Attribute("type", &(pIndicator[a].modelType));
			int x, y;
			pIndicatorList->Attribute("x", &(x));
			pIndicator[a].fX = x;
			pIndicatorList->Attribute("y", &(y));
			pIndicator[a].fY = y;
			pIndicator[a].bShow = TRUE;

			pIndicatorList = pIndicatorList->NextSiblingElement();
		}
	}
	//adding Indicator to MObjectSet
	pMObjectSet->pIndicator = pIndicator;
	return pMObjectSet;
}
