/* ================================================================
 * EnhancedPreferences API - Alternative preferences package
 * ================================================================
 * 
 * Project Info:  http://development.poopu.com/ehprefs
 * Project Lead:  Justin Kim(jst.kim@gmail.com)
 * Create Date : 2004. 11. 22
 *
 * (C) Copyright 2004, by Justin Kim
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.poopu.util.prefs;

import java.util.Arrays;
import java.util.prefs.Preferences;

import junit.framework.TestCase;

/**
 * @author jskim
 *
 */
public class EnhancedPreferencesTest extends TestCase
{

  /*
   * @see TestCase#setUp()
   */
  protected void setUp() throws Exception
  {
    System.setProperty("java.util.prefs.PreferencesFactory",
        EnhancedPreferencesFactory.class.getName());
    
    Preferences nodePrefs = Preferences.userNodeForPackage(String.class);
    nodePrefs.put("test_java_lang1", "test_java_lang1");
    nodePrefs.put("test_java_lang2", "test_java_lang2");
    nodePrefs.put("test_java_lang3", "test_java_lang3");
    nodePrefs.put("test_java_lang4", "test_java_lang4");
  }
  
  public void testUserNodeForPackage()
  {
    Preferences nodePrefs = Preferences.userNodeForPackage(getClass());
    assertNotNull(nodePrefs);    
  }
  
  public void testPut()
  {
    Preferences nodePrefs = Preferences.userNodeForPackage(getClass());
    assertNotNull(nodePrefs);
    nodePrefs.put("testKey1", "testKey_value");
    String testValue = nodePrefs.get("testKey1", "DefaultValue");
    assertEquals("testKey_value", testValue);
  }
  
  public void testKeys() throws Exception
  {
    Preferences nodePrefs = Preferences.userNodeForPackage(getClass());
    assertNotNull(nodePrefs);
    String[] keys = nodePrefs.keys();
    assertNotNull(keys);
    System.out.println(Arrays.asList(keys));
  }
  
  public void testChildrenNames() throws Exception
  {
    Preferences nodePrefs = Preferences.userRoot();
    assertNotNull(nodePrefs);
    String[] names = nodePrefs.childrenNames();
    assertNotNull(names);
    System.out.println(Arrays.asList(names));
  }
  
  public void testRemoveNode() throws Exception
  {
    Preferences nodePrefs = Preferences.systemNodeForPackage(String.class);
    assertNotNull(nodePrefs);
    nodePrefs.put("test_java_lang1", "test_java_lang1");
    nodePrefs.put("test_java_lang2", "test_java_lang2");
    nodePrefs.put("test_java_lang3", "test_java_lang3");
    nodePrefs.put("test_java_lang4", "test_java_lang4");
    
    nodePrefs.removeNode();
  }
  
  public void testRemove()
  {
    Preferences nodePrefs = Preferences.userNodeForPackage(String.class);
    assertNotNull(nodePrefs);
    nodePrefs.remove("test_java_lang1");    
  }
}