/* ================================================================
 * EnhancedPreferences API - Alternative preferences package
 * ================================================================
 * 
 * Project Info:  http://development.poopu.com/ehprefs
 * Project Lead:  Justin Kim(jst.kim@gmail.com)
 * Create Date : 2004. 11. 3
 *
 * (C) Copyright 2004, by Justin Kim
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.poopu.util.prefs;

import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

import com.poopu.util.prefs.impl.PreferencesProviderImpl;

/**
 * @author jskim
 *
 */
public final class EnhancedPreferencesFactory implements PreferencesFactory
{
  public final static String EH_PREFS_PROPERTIES = "ehprefs.properties";

  public final static Integer USER_NODE = new Integer(1);

  public final static Integer SYSTEM_NODE = new Integer(0);

  private MutablePicoContainer pico;

  /**
   * 
   */
  public EnhancedPreferencesFactory()
  {
    super();
    pico = new DefaultPicoContainer();
    pico.registerComponentImplementation(PreferencesProvider.class,
        PreferencesProviderImpl.class);
  }

  private PreferencesProvider getProvider()
  {
    PreferencesProvider prefsProvider = (PreferencesProvider) pico
        .getComponentInstance(PreferencesProvider.class);
    return prefsProvider;
  }

  /* (non-Javadoc)
   * @see java.util.prefs.PreferencesFactory#systemRoot()
   */
  public Preferences systemRoot()
  {
    return getProvider().getSystemRoot();
  }

  /* (non-Javadoc)
   * @see java.util.prefs.PreferencesFactory#userRoot()
   */
  public Preferences userRoot()
  {
    return getProvider().getUserRoot();
  }

}