/*
 * Decompiled with CFR 0.152.
 */
package com.poopu.util.prefs.impl;

import com.poopu.util.prefs.EnhancedPreferencesFactory;
import com.poopu.util.prefs.PreferencesProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultPicoContainer;

public class PreferencesProviderImpl
implements PreferencesProvider {
    private static final Log log;
    private static Properties props;
    private static boolean loadFlag;
    static Preferences userRoot;
    static Preferences systemRoot;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.poopu.util.prefs.impl.PreferencesProviderImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        props = new Properties();
        loadFlag = false;
    }

    public PreferencesProviderImpl() {
        StringBuffer stringBuffer = new StringBuffer("Creating ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.poopu.util.prefs.impl.PreferencesProviderImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log.trace((Object)stringBuffer.append(clazz).append(".").toString());
        if (!loadFlag) {
            props = this.loadProperties();
        }
    }

    private Properties loadProperties() {
        log.trace((Object)"Loading EnhancedPreferences properties file.");
        String propertiesFile = System.getProperty("ehprefs.properties", "ehprefs.properties");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile);
        try {
            props.load(is);
            loadFlag = true;
        }
        catch (IOException e) {
            log.warn((Object)"Can't load properties.", (Throwable)e);
        }
        return props;
    }

    private Preferences getPreferences(Class clazz, Integer nodeType) {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        Parameter[] param = new Parameter[]{new ConstantParameter((Object)nodeType)};
        pico.registerComponentImplementation((Object)clazz, clazz, param);
        log.debug((Object)("creating Preferences Object : " + clazz.getName()));
        Preferences prefs = (Preferences)pico.getComponentInstance((Object)clazz);
        return prefs;
    }

    public Preferences getSystemRoot() {
        if (systemRoot == null) {
            log.debug((Object)"creating systemRoot prefs instance.");
            try {
                Class<?> clazz = Class.forName(props.getProperty("systemPreferences.class"));
                systemRoot = this.getPreferences(clazz, EnhancedPreferencesFactory.SYSTEM_NODE);
            }
            catch (Throwable t) {
                log.warn((Object)"Can't get systemRoot instance.", t);
            }
        }
        return systemRoot;
    }

    public Preferences getUserRoot() {
        if (userRoot == null) {
            log.debug((Object)"creating userRoot prefs instance.");
            try {
                Class<?> clazz = Class.forName(props.getProperty("userPreferences.class"));
                userRoot = this.getPreferences(clazz, EnhancedPreferencesFactory.USER_NODE);
            }
            catch (Throwable t) {
                log.warn((Object)"Can't get userRoot instance.", t);
            }
        }
        return userRoot;
    }

    public Properties getProperties() {
        if (!loadFlag) {
            this.loadProperties();
        }
        return props;
    }
}

