/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.queue;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.QueueSession;
import org.kldp.ebmsh.queue.EbmsQueueException;
import org.kldp.ebmsh.queue.EbmsQueueMessageException;
import org.kldp.ebmsh.queue.MessageConverter;
import org.kldp.ebmsh.queue.QueueMessage;
import org.kldp.ebmsh.queue.ToApplicationMessage;

public class ToApplicationMessageConverter
implements MessageConverter {
    public Message convertToJMSMessage(QueueSession queueSession, QueueMessage queueMessage) throws EbmsQueueMessageException {
        MapMessage message = null;
        ToApplicationMessage _applicationMessage = (ToApplicationMessage)queueMessage;
        try {
            this.validateMessage(_applicationMessage);
            message = queueSession.createMapMessage();
            message.setLong("uid", _applicationMessage.getUid());
            message.setString("messageId", _applicationMessage.getMessageId());
            message.setString("cpaId", _applicationMessage.getCpaId());
            message.setString("from", _applicationMessage.getFrom());
            message.setString("to", _applicationMessage.getTo());
            message.setString("action", _applicationMessage.getAction());
            message.setString("conversationId", _applicationMessage.getConversationId());
            message.setString("service", _applicationMessage.getService());
            message.setString("timestamp", _applicationMessage.getTimestamp());
            message.setBoolean("block", _applicationMessage.getBlock());
            if (_applicationMessage.getPayloadCount() != 0) {
                message.setInt("payloadCount", _applicationMessage.getPayloadCount());
                int i = 0;
                while (i < _applicationMessage.getPayloadCount()) {
                    message.setBytes("payload" + i, _applicationMessage.getPayloads()[i]);
                    ++i;
                }
            } else {
                message.setInt("payloadCount", 0);
            }
        }
        catch (JMSException e) {
            throw new EbmsQueueMessageException(0, 0, e);
        }
        return message;
    }

    public QueueMessage convertToQueueMessage(Message message) throws EbmsQueueMessageException {
        ToApplicationMessage applicationMessage = null;
        MapMessage mapMessage = null;
        try {
            this.validateMessage(message);
            applicationMessage = new ToApplicationMessage();
            mapMessage = (MapMessage)message;
            applicationMessage.setUid(mapMessage.getLong("uid"));
            applicationMessage.setMessageId(mapMessage.getString("messageId"));
            applicationMessage.setCpaId(mapMessage.getString("cpaId"));
            applicationMessage.setFrom(mapMessage.getString("from"));
            applicationMessage.setTo(mapMessage.getString("to"));
            applicationMessage.setAction(mapMessage.getString("action"));
            applicationMessage.setConversationId(mapMessage.getString("conversationId"));
            applicationMessage.setService(mapMessage.getString("service"));
            applicationMessage.setTimestamp(mapMessage.getString("timestamp"));
            applicationMessage.setBlock(mapMessage.getBoolean("block"));
            int payloadCount = mapMessage.getInt("payloadCount");
            if (payloadCount != 0) {
                byte[][] payloads = new byte[payloadCount][0];
                int i = 0;
                while (i < payloadCount) {
                    payloads[i] = mapMessage.getBytes("payload" + i);
                    ++i;
                }
                applicationMessage.setPayloads(payloads);
            } else {
                applicationMessage.setPayloadCount(0);
            }
        }
        catch (JMSException e) {
            throw new EbmsQueueMessageException(0, 0, e);
        }
        return applicationMessage;
    }

    public void validateMessage(Message message) throws EbmsQueueMessageException {
        try {
            byte[] tmpPayload;
            if (message == null) {
                throw new IllegalArgumentException("Message\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!(message instanceof MapMessage)) {
                throw new IllegalArgumentException("Message \ud0c0\uc785\uc774 MapMessage\uac00 \uc544\ub2d9\ub2c8\ub2e4.");
            }
            MapMessage _mapMessage = (MapMessage)message;
            if (!_mapMessage.itemExists("uid")) {
                throw new IllegalArgumentException("UID\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("cpaId")) {
                throw new IllegalArgumentException("CpaId\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("from")) {
                throw new IllegalArgumentException("From\uc774 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("to")) {
                throw new IllegalArgumentException("To\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("service")) {
                throw new IllegalArgumentException("Service\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("conversationId")) {
                throw new IllegalArgumentException("ConversationId\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("action")) {
                throw new IllegalArgumentException("Action\uc774 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("messageId")) {
                throw new IllegalArgumentException("MessageId\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("timestamp")) {
                throw new IllegalArgumentException("Timestamp\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("payloadCount")) {
                throw new IllegalArgumentException("PayloadCount\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("block")) {
                throw new IllegalArgumentException("Block\uac00 null\uc785\ub2c8\ub2e4.");
            }
            int payloadCount = _mapMessage.getInt("payloadCount");
            if (payloadCount != 0 && (tmpPayload = _mapMessage.getBytes("payload" + (payloadCount - 1))) == null) {
                throw new IllegalArgumentException("\ucca8\ubd80\ubb38\uc11c \uac1c\uc218\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (IllegalArgumentException e) {
            throw new EbmsQueueMessageException(1, 0, e);
        }
        catch (JMSException e) {
            throw new EbmsQueueMessageException(1, 0, e);
        }
    }

    public void validateMessage(QueueMessage queueMessage) throws EbmsQueueMessageException {
        try {
            if (queueMessage == null) {
                throw new IllegalArgumentException("ToApplicationMessage\uac00 null\uc785\ub2c8\ub2e4.");
            }
        }
        catch (IllegalArgumentException e) {
            throw new EbmsQueueException(1, 0, e);
        }
    }
}

