/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageFactoryImpl;

public class WSRMUtil {
    private TransformerFactory transformerFac = null;
    private Transformer transformer = null;
    private MessageFactory jaxmFac = null;
    private ServerSocketFactory ssocfac = null;
    private SocketFactory socfac = null;

    public WSRMUtil() {
        try {
            this.jaxmFac = MessageFactory.newInstance();
            this.transformerFac = TransformerFactory.newInstance();
            this.transformer = this.transformerFac.newTransformer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SOAPMessage createSOAPMessage() throws SOAPException {
        try {
            return this.getMessageFactory().createMessage();
        }
        catch (SOAPException se) {
            throw new SOAPException("SOAP error creating JAXM message.", (Throwable)se);
        }
    }

    public MessageFactory getMessageFactory() {
        return this.jaxmFac;
    }

    public SOAPMessage fileToSOAP(File xmlFile) throws SOAPException {
        SOAPMessage jaxm = this.createSOAPMessage();
        try {
            StreamSource src = new StreamSource(new FileInputStream(xmlFile));
            jaxm.getSOAPPart().setContent((Source)src);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        catch (SOAPException se) {
            se.printStackTrace();
        }
        return jaxm;
    }

    public SOAPMessage stringToSOAP(String str) throws SOAPException {
        SOAPMessage jaxm = this.createSOAPMessage();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        try {
            StreamSource src = new StreamSource(in);
            jaxm.getSOAPPart().setContent((Source)src);
        }
        catch (SOAPException se) {
            se.printStackTrace();
        }
        return jaxm;
    }

    public static SOAPMessage stringToSOAP(ByteArrayOutputStream ot) {
        SOAPMessage jaxm = null;
        try {
            EbxmlMessageFactoryImpl f = new EbxmlMessageFactoryImpl();
            jaxm = f.createMessage();
            ByteArrayInputStream in = new ByteArrayInputStream(ot.toByteArray());
            StreamSource src = new StreamSource(in);
            jaxm.getSOAPPart().setContent((Source)src);
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        return jaxm;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFac;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

