/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.GDuration;
import org.kldp.ebmsh.message.packaging.EBXMLMimeMultipart;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.util.ByteArrayDataSource;
import org.kldp.ebmsh.message.util.MultipartDataSource;
import org.kldp.util.log.LogUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageUtil {
    private static Log log = LogFactory.getLog(MessageUtil.class);

    public static void lookingGood(EbxmlMessage msg) {
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            Source sc = msg.getSOAPPart().getContent();
            StreamResult result = new StreamResult(System.out);
            tf.transform(sc, result);
            System.out.println();
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public static String generateMessageId(String partyTo, String CPAId2, String service, String action) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(new Date());
        String year = String.valueOf(c.get(1));
        while (year.length() < 4) {
            year = "0" + year;
        }
        String month = String.valueOf(c.get(2) + 1);
        while (month.length() < 2) {
            month = "0" + month;
        }
        String day = String.valueOf(c.get(5));
        while (day.length() < 2) {
            day = "0" + day;
        }
        String hour = String.valueOf(c.get(11));
        while (hour.length() < 2) {
            hour = "0" + hour;
        }
        String minute = String.valueOf(c.get(12));
        while (minute.length() < 2) {
            minute = "0" + minute;
        }
        String second = String.valueOf(c.get(13));
        while (second.length() < 2) {
            second = "0" + second;
        }
        String milliSecond = String.valueOf(c.get(14));
        while (milliSecond.length() < 3) {
            milliSecond = "0" + milliSecond;
        }
        Random r = new Random();
        StringBuffer localPart = new StringBuffer();
        localPart.append(year).append(month).append(day).append("-");
        localPart.append(hour).append(minute).append(second).append(milliSecond).append("-").append(CPAId2).append(".");
        localPart.append("service" + String.valueOf(r.nextInt())).append(".").append(action).append(".");
        String domain = "unknownDomain";
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            domain = localAddr.getHostAddress();
        }
        catch (UnknownHostException localAddr) {
            // empty catch block
        }
        String messageId = String.valueOf(localPart.toString()) + "@" + domain;
        return messageId;
    }

    public static String generateShortMessageId(String partyTo, String CPAId2, String service, String action) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(new Date());
        String year = String.valueOf(c.get(1));
        while (year.length() < 4) {
            year = "0" + year;
        }
        String month = String.valueOf(c.get(2) + 1);
        while (month.length() < 2) {
            month = "0" + month;
        }
        String day = String.valueOf(c.get(5));
        while (day.length() < 2) {
            day = "0" + day;
        }
        String hour = String.valueOf(c.get(11));
        while (hour.length() < 2) {
            hour = "0" + hour;
        }
        String minute = String.valueOf(c.get(12));
        while (minute.length() < 2) {
            minute = "0" + minute;
        }
        String second = String.valueOf(c.get(13));
        while (second.length() < 2) {
            second = "0" + second;
        }
        String milliSecond = String.valueOf(c.get(14));
        while (milliSecond.length() < 3) {
            milliSecond = "0" + milliSecond;
        }
        Random r = new Random();
        StringBuffer localPart = new StringBuffer();
        localPart.append(year).append(month).append(day).append("-");
        localPart.append(hour).append(minute).append(second).append(milliSecond);
        localPart.append(action);
        String messageId = localPart.toString();
        return messageId;
    }

    public static String getMessage(EbxmlMessage em) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            em.writeTo(bo);
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return bo.toString();
    }

    public static String getSOAPMessage(SOAPMessage em) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            em.writeTo((OutputStream)bo);
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return bo.toString();
    }

    public static String dateToUTC(Date date) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(date);
        String year = String.valueOf(c.get(1));
        while (year.length() < 4) {
            year = "0" + year;
        }
        String month = String.valueOf(c.get(2) + 1);
        while (month.length() < 2) {
            month = "0" + month;
        }
        String day = String.valueOf(c.get(5));
        while (day.length() < 2) {
            day = "0" + day;
        }
        String hour = String.valueOf(c.get(11));
        while (hour.length() < 2) {
            hour = "0" + hour;
        }
        String minute = String.valueOf(c.get(12));
        while (minute.length() < 2) {
            minute = "0" + minute;
        }
        String second = String.valueOf(c.get(13));
        while (second.length() < 2) {
            second = "0" + second;
        }
        String timeStamp = String.valueOf(year) + "-" + month + "-" + day + "T" + hour + ":" + minute + ":" + second + "Z";
        return timeStamp;
    }

    public static Date utcToDate(String utcString) {
        int count;
        ArrayList<String> parts;
        block8: {
            try {
                parts = new ArrayList<String>();
                int i = 0;
                int j = 0;
                while (i < utcString.length()) {
                    if ("-+:TZ.".indexOf(utcString.charAt(i)) != -1 || i == utcString.length() - 1) {
                        parts.add(utcString.substring(j, i));
                        j = i + 1;
                    }
                    ++i;
                }
                count = parts.size();
                if (count >= 6) break block8;
                return null;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return null;
            }
        }
        int year = Integer.parseInt((String)parts.get(0));
        int month = Integer.parseInt((String)parts.get(1));
        int day = Integer.parseInt((String)parts.get(2));
        int hour = Integer.parseInt((String)parts.get(3));
        int minute = Integer.parseInt((String)parts.get(4));
        int second = Integer.parseInt((String)parts.get(5));
        if (count == 8) {
            int hourOffset = Integer.parseInt((String)parts.get(6));
            int minOffset = Integer.parseInt((String)parts.get(7));
            if (utcString.indexOf("+") != -1) {
                hour -= hourOffset;
                minute -= minOffset;
            } else {
                hour += hourOffset;
                minute += minOffset;
            }
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.clear();
        c.set(year, month - 1, day, hour, minute, second);
        return c.getTime();
    }

    public long convertUTCDuration(String utcDuration) {
        long millisecond = 0L;
        String temp = utcDuration.substring(utcDuration.indexOf("P"));
        String day = temp.substring(0, temp.indexOf("T"));
        String time = temp.substring(temp.indexOf("T") + 1);
        String[] utc = new String[6];
        if (day.length() > 0) {
            utc[0] = day.substring(0, day.indexOf(89));
            utc[1] = day.substring(day.indexOf(89) + 1, day.indexOf(77));
            utc[2] = day.substring(day.indexOf(77) + 1, day.indexOf(68));
        }
        if (time.length() > 0) {
            utc[3] = time.substring(0, time.indexOf(72));
            utc[4] = time.substring(time.indexOf(72) + 1, time.indexOf("M"));
            utc[5] = time.substring(time.indexOf(77) + 1, time.indexOf("S"));
        }
        int[] millis = new int[6];
        int i = 0;
        while (i < 6) {
            if (utc[i].length() > 0) {
                switch (i) {
                    case 0: {
                        millisecond += (long)(Integer.parseInt(utc[i]) * 365 * 24 * 3600);
                        break;
                    }
                    case 1: {
                        millisecond += (long)(Integer.parseInt(utc[i]) * 30 * 24 * 3600);
                        break;
                    }
                    case 2: {
                        millisecond += (long)(Integer.parseInt(utc[i]) * 24 * 3600);
                        break;
                    }
                    case 3: {
                        millisecond += (long)(Integer.parseInt(utc[i]) * 3600);
                        break;
                    }
                    case 4: {
                        millisecond += (long)(Integer.parseInt(utc[i]) * 60);
                        break;
                    }
                    case 5: {
                        millisecond += (long)Integer.parseInt(utc[i]);
                    }
                }
            }
            ++i;
        }
        return millisecond * 1000L;
    }

    public static long gdurationToLong(GDuration duration) {
        long time = 0L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(duration.getYear(), duration.getMonth(), duration.getDay(), duration.getHour(), duration.getMinute(), duration.getSecond());
        Calendar calendar_ = Calendar.getInstance();
        calendar_.set(0, 0, 0, 0, 0, 0);
        time = calendar.getTimeInMillis() - calendar_.getTimeInMillis();
        return time;
    }

    public static SOAPElement convertDOMToSOAPElement(SOAPEnvelope env, Node DOMNode) throws SOAPException {
        if (DOMNode.getNodeType() != 1) {
            throw new SOAPException("DOMNode must of type ELEMENT_NODE");
        }
        SOAPFactory sef = SOAPFactory.newInstance();
        SOAPElement se = sef.createElement(DOMNode.getLocalName(), DOMNode.getPrefix(), DOMNode.getNamespaceURI());
        if (DOMNode.hasAttributes()) {
            NamedNodeMap DOMAttributes = DOMNode.getAttributes();
            int noOfAttributes = DOMAttributes.getLength();
            int i = 0;
            while (i < noOfAttributes) {
                Node attr = DOMAttributes.item(i);
                se.addAttribute(env.createName(attr.getLocalName(), attr.getPrefix(), attr.getNamespaceURI()), attr.getNodeValue());
                ++i;
            }
        }
        if (DOMNode.hasChildNodes()) {
            NodeList children = DOMNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 7: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 3: {
                        se.addTextNode(child.getNodeValue());
                        break;
                    }
                    default: {
                        se.addChildElement(MessageUtil.convertDOMToSOAPElement(env, child));
                    }
                }
                ++i;
            }
        }
        return se;
    }

    public static String buildMimepartEbxmlMessage(EbxmlMessage ebxmlMessage) {
        try {
            String resultEbxmlMessageString = null;
            MimeHeaders mimeHeaders = ebxmlMessage.getMimeHeaders();
            String contentType = mimeHeaders.getHeader("Content-Type")[0];
            if (contentType.startsWith("text/xml")) {
                ByteArrayDataSource bas = new ByteArrayDataSource(MessageUtil.getSOAPMessage(ebxmlMessage), "text/xml");
                EBXMLMimeMultipart mp = new EBXMLMimeMultipart(bas);
                MimeBodyPart mb = mp.getRootPart();
                MultipartDataSource ds = new MultipartDataSource(MessageUtil.getSOAPMessage(ebxmlMessage));
                ds.setContentTypeAndId(mb.getContentType(), mb.getContentID());
                ContentType ct = mp.getContentType();
                String bnd = ct.getParameter("boundary");
                ds.setBoundary(bnd);
                resultEbxmlMessageString = ds.getString();
            } else if (contentType.startsWith("multipart/related")) {
                resultEbxmlMessageString = ebxmlMessage.toString();
            }
            return resultEbxmlMessageString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isMimepartEbxmlMessage(EbxmlMessage ebxmlMessage) {
        try {
            MimeHeaders mimeHeaders = ebxmlMessage.getMimeHeaders();
            String contentType = mimeHeaders.getHeader("Content-Type")[0];
            return contentType.startsWith("multipart/related");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isSystemLevelActionMessage(EbxmlMessage ebxmlMessage) {
        String action = ebxmlMessage.getAction();
        return action.equals("Acknowledgment") || action.equals("MessageStatusRequest") || action.equals("MessageStatusResponse") || action.equals("MessageError") || action.equals("Ping") || action.equals("Pong");
    }
}

