/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.util;

import java.util.Date;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.cpa.Cpa;
import org.kldp.ebmsh.cpa.CpaManagerFactory;
import org.kldp.ebmsh.cpa.DeliveryChannel;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.kldp.ebmsh.cpa.PartyInfo;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.TimeToLive;
import org.kldp.ebmsh.message.packaging.impl.AcknowledgmentMessage;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageFactoryImpl;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageImpl;
import org.kldp.ebmsh.message.packaging.impl.ErrorMessage;
import org.kldp.ebmsh.message.security.EbmsKeyStoreException;
import org.kldp.ebmsh.message.security.EbmsSignException;
import org.kldp.ebmsh.message.security.EbmsSignature;
import org.kldp.ebmsh.message.util.MessageUtil;
import org.kldp.ebmsh.message.util.StringDataSource;

public class MessageBuilderUtil {
    private static final Log log = LogFactory.getLog(MessageBuilderUtil.class);

    private static AcknowledgmentMessage createAckEbxmlMessageTemplate(String fromPartyId, String toPartyId, String cpaId, String conversationId, String action, String service, String serviceType) throws EbmsEbxmlMessageException {
        AcknowledgmentMessage em = null;
        try {
            EbxmlMessageFactoryImpl mf = new EbxmlMessageFactoryImpl();
            SOAPMessage sm = mf.createMessage();
            em = new AcknowledgmentMessage(sm, mf);
            em.initNameSpace();
            em.initMessageHeader();
            em.setCPAId(cpaId);
            em.setFrom(fromPartyId, "urn:oasis:names:tc:ebxml-cppa:partyid-type:duns");
            em.setTo(toPartyId, "urn:oasis:names:tc:ebxml-cppa:partyid-type:duns");
            if (serviceType == null || serviceType == "") {
                em.setService(service);
            } else {
                em.setService(service, serviceType);
            }
            em.setConversationId(conversationId);
            em.setAction(action);
            String messageId = MessageUtil.generateMessageId(toPartyId, cpaId, service, action);
            em.setMessageId(messageId);
            String timestamp = MessageUtil.dateToUTC(new Date());
            em.setTimestamp(timestamp);
            TimeToLive tl = em.getEbxmlHeader().getMessageHeader().getMessageData().addTimeToLive();
            tl.setTimeToLive(MessageUtil.dateToUTC(new Date(System.currentTimeMillis() + 5000L)));
            em.saveChanges();
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "\uba54\uc2dc\uc9c0 \uc0dd\uc131 \uc5d0\ub7ec", e);
        }
        return em;
    }

    private static EbxmlMessage createEbxmlMessageTemplate(String fromPartyId, String toPartyId, String cpaId, String conversationId, String action, String service, String serviceType) throws EbmsEbxmlMessageException {
        EbxmlMessageImpl em = null;
        try {
            EbxmlMessageFactoryImpl mf = new EbxmlMessageFactoryImpl();
            SOAPMessage sm = mf.createMessage();
            em = new EbxmlMessageImpl(sm, mf);
            em.initNameSpace();
            em.initMessageHeader();
            em.setCPAId(cpaId);
            em.setFrom(fromPartyId, "urn:oasis:names:tc:ebxml-cppa:partyid-type:duns");
            em.setTo(toPartyId, "urn:oasis:names:tc:ebxml-cppa:partyid-type:duns");
            if (serviceType == null || serviceType == "") {
                em.setService(service);
            } else {
                em.setService(service, serviceType);
            }
            em.setConversationId(conversationId);
            em.setAction(action);
            String messageId = MessageUtil.generateMessageId(toPartyId, cpaId, service, action);
            em.setMessageId(messageId);
            String timestamp = MessageUtil.dateToUTC(new Date());
            em.setTimestamp(timestamp);
            TimeToLive tl = em.getEbxmlHeader().getMessageHeader().getMessageData().addTimeToLive();
            tl.setTimeToLive(MessageUtil.dateToUTC(new Date(System.currentTimeMillis() + 5000L)));
            em.saveChanges();
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "\uba54\uc2dc\uc9c0 \uc0dd\uc131 \uc5d0\ub7ec", e);
        }
        return em;
    }

    public static EbxmlMessage buildCustomActionMessage(String fromPartyId, String toPartyId, String cpaId, String conversationId, String action, String service) throws EbmsEbxmlMessageException {
        EbxmlMessage em = null;
        try {
            em = MessageBuilderUtil.createEbxmlMessageTemplate(fromPartyId, toPartyId, cpaId, conversationId, action, service, "ebXMLBPMS");
            MimeHeaders mimeHeaders = em.getMimeHeaders();
            System.out.println("1: " + mimeHeaders.getHeader("Content-Type")[0]);
            MessageBuilderUtil.checkSyncReply(em);
            MessageBuilderUtil.checkAckRequest(em);
            MessageBuilderUtil.checkDuplicateElimination(em);
            MessageBuilderUtil.checkEbxmlMessageSign(em);
        }
        catch (EbmsCpaException e) {
            throw new EbmsEbxmlMessageException(1, 0, "\uba54\uc2dc\uc9c0 \uc0dd\uc131 \uc5d0\ub7ec", e);
        }
        return em;
    }

    public static EbxmlMessage buildCustomActionMessageWithPayloads(String fromPartyId, String toPartyId, String cpaId, String conversationId, String action, String service, byte[][] payloads) throws EbmsEbxmlMessageException {
        EbxmlMessage em = null;
        try {
            em = MessageBuilderUtil.createEbxmlMessageTemplate(fromPartyId, toPartyId, cpaId, conversationId, action, service, "ebXMLBPMS");
            int i = 0;
            while (i < payloads.length) {
                StringDataSource ds = new StringDataSource(new String(payloads[i]), "text/xml");
                DataHandler dh = new DataHandler((DataSource)ds);
                em.addPayload(dh, "contentid-" + String.valueOf(i) + "@softmeca.com");
                ++i;
            }
            em.saveChanges();
            MessageBuilderUtil.checkSyncReply(em);
            MessageBuilderUtil.checkAckRequest(em);
            MessageBuilderUtil.checkDuplicateElimination(em);
            MessageBuilderUtil.checkEbxmlMessageSign(em);
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "\uba54\uc2dc\uc9c0 \uc0dd\uc131 \uc5d0\ub7ec", e);
        }
        catch (EbmsCpaException e) {
            throw new EbmsEbxmlMessageException(1, 0, "\uba54\uc2dc\uc9c0 \uc0dd\uc131 \uc5d0\ub7ec", e);
        }
        return em;
    }

    public static ErrorMessage buildMessageErrorMessage(EbxmlMessage receiveEbxmlMessage) throws EbmsEbxmlMessageException {
        ErrorMessage em = null;
        try {
            String cpaId = receiveEbxmlMessage.getCPAId();
            String toPartyId = receiveEbxmlMessage.getFrom();
            String fromPartyId = receiveEbxmlMessage.getTo();
            String conversationId = receiveEbxmlMessage.getConversationId();
            String action = "MessageError";
            String service = "urn:oasis:names:tc:ebxml-msg:service";
            EbxmlMessage tmpEbxmlMessage = MessageBuilderUtil.createEbxmlMessageTemplate(fromPartyId, toPartyId, cpaId, conversationId, action, service, "");
            tmpEbxmlMessage.getEbxmlHeader().getMessageHeader().getMessageData().addRefToMessageId().setValue(receiveEbxmlMessage.getMessageId());
            em = new ErrorMessage(tmpEbxmlMessage, null);
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
        return em;
    }

    public static AcknowledgmentMessage buildAcknowledgmentMessage(EbxmlMessage receiveEbxmlMessage) throws EbmsEbxmlMessageException {
        AcknowledgmentMessage em = null;
        try {
            String refToMessageId = receiveEbxmlMessage.getMessageId();
            String action = "Acknowledgment";
            String service = "urn:oasis:names:tc:ebxml-msg:service";
            em = MessageBuilderUtil.createAckEbxmlMessageTemplate(receiveEbxmlMessage.getTo(), receiveEbxmlMessage.getFrom(), receiveEbxmlMessage.getCPAId(), receiveEbxmlMessage.getConversationId(), action, service, "");
            Date date = new Date();
            String timestamp = MessageUtil.dateToUTC(date);
            em.setAcknowledgment(refToMessageId, receiveEbxmlMessage.getTo(), timestamp);
            String s_Actor = null;
            Iterator it = receiveEbxmlMessage.getEbxmlHeader().getAckRequested().getAllAttributes();
            while (it.hasNext()) {
                Name t = (Name)it.next();
                if (!t.getLocalName().equals("actor")) continue;
                s_Actor = receiveEbxmlMessage.getEbxmlHeader().getAckRequested().getAttributeValue(t);
            }
            if (s_Actor != null) {
                em.getAcknowledgment().setActor(s_Actor);
            } else {
                em.getAcknowledgment().setActor("urn:oasis:names:tc:ebxml-msg:actor:toPartyMSH");
            }
            MessageBuilderUtil.checkDuplicateElimination(em);
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
        return em;
    }

    public static EbxmlMessage buildPongMessage(EbxmlMessage receiveEbxmlMessage) throws EbmsEbxmlMessageException {
        EbxmlMessage em = null;
        try {
            String fromPartyId = receiveEbxmlMessage.getTo();
            String toPartyId = receiveEbxmlMessage.getFrom();
            String conversationId = receiveEbxmlMessage.getConversationId();
            String cpaId = receiveEbxmlMessage.getCPAId();
            String refToMessageId = receiveEbxmlMessage.getMessageId();
            String action = "Pong";
            String service = "urn:oasis:names:tc:ebxml-msg:service";
            em = MessageBuilderUtil.createEbxmlMessageTemplate(fromPartyId, toPartyId, cpaId, conversationId, action, service, "");
            em.getEbxmlHeader().getMessageHeader().getMessageData().addRefToMessageId().setValue(refToMessageId);
            MessageBuilderUtil.checkSyncReply(em);
            MessageBuilderUtil.checkAckRequest(em);
            MessageBuilderUtil.checkDuplicateElimination(em);
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
        return em;
    }

    private static void checkSyncReply(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException, EbmsCpaException {
        log.info((Object)"CPA\uc758 SyncReply\ub97c \uac80\uc0ac\ud569\ub2c8\ub2e4.");
        try {
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            if (cpa == null) {
                throw new EbmsCpaException(1, 0, "CPA\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            PartyInfo party = cpa.getPartyInfo(ebxmlMessage.getFrom());
            if (party == null) {
                throw new EbmsCpaException(1, 0, "Party\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            String syncReplyMode = null;
            if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                String defaultMshChannelId = party.getDefaultMshChannelId();
                syncReplyMode = party.getDeliveryChannel(defaultMshChannelId).getSyncReplyMode();
            } else {
                syncReplyMode = party.getDeliveryChannelByAction(ebxmlMessage.getAction()).getSyncReplyMode();
            }
            if (syncReplyMode == null) {
                throw new EbmsCpaException(1, 0, "SyncReplyMode\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            boolean isSync = false;
            if (syncReplyMode.equals("mshSignalsOnly") || syncReplyMode.equals("signalsOnly") || syncReplyMode.equals("responseOnly") || syncReplyMode.equals("signalsAndResponse")) {
                isSync = true;
            }
            log.info((Object)("Sync => " + syncReplyMode));
            if (isSync) {
                log.info((Object)"SyncReply\ub97c \ucd94\uac00\ud569\ub2c8\ub2e4.");
                if (!ebxmlMessage.getEbxmlHeader().hasSyncReply()) {
                    ebxmlMessage.getEbxmlHeader().addSyncReply();
                }
            }
            ebxmlMessage.saveChanges();
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "Sync Reply \uac80\uc0ac \uc5d0\ub7ec", e);
        }
    }

    private static void checkAckRequest(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException, EbmsCpaException {
        log.info((Object)"CPA\uc758 AckRequested\ub97c \uac80\uc0ac\ud569\ub2c8\ub2e4.");
        try {
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            if (cpa == null) {
                throw new EbmsCpaException(1, 0, "CPA\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            PartyInfo party = cpa.getPartyInfo(ebxmlMessage.getFrom());
            if (party == null) {
                throw new EbmsCpaException(1, 0, "Party\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            String ackRequested = null;
            String ackRequestedSign = null;
            if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                String defaultMshChannelId = party.getDefaultMshChannelId();
                ackRequested = party.getDeliveryChannel(defaultMshChannelId).getAckRequested();
                ackRequestedSign = party.getDeliveryChannel(defaultMshChannelId).getAckSignatureRequested();
            } else {
                ackRequested = party.getDeliveryChannelByAction(ebxmlMessage.getAction()).getAckRequested();
                ackRequestedSign = party.getDeliveryChannelByAction(ebxmlMessage.getAction()).getAckSignatureRequested();
            }
            boolean isAckRequest = false;
            if (ackRequested.equals("always")) {
                isAckRequest = true;
            }
            log.info((Object)("AckRequested => " + ackRequested));
            if (isAckRequest) {
                log.info((Object)"AckRequested\ub97c \ucd94\uac00\ud569\ub2c8\ub2e4.");
                if (!ebxmlMessage.getEbxmlHeader().hasAckRequested()) {
                    ebxmlMessage.getEbxmlHeader().addAckRequested();
                }
                ebxmlMessage.saveChanges();
            }
            boolean isAckRequestSign = false;
            if (isAckRequest) {
                if (ackRequestedSign.equals("always")) {
                    isAckRequestSign = true;
                }
                log.info((Object)("AckRequestedSign => " + ackRequestedSign));
                if (isAckRequestSign) {
                    log.info((Object)"AckRequested\uc5d0 Sign\uc744 true\ub85c \uc124\uc815\ud569\ub2c8\ub2e4.");
                    ebxmlMessage.getEbxmlHeader().getAckRequested().setSigned(true);
                    ebxmlMessage.saveChanges();
                }
            }
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "AckRequested \uac80\uc0ac \uc5d0\ub7ec", e);
        }
    }

    private static void checkDuplicateElimination(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException, EbmsCpaException {
        log.info((Object)"CPA\uc758 DuplicateElimination\uc744 \uac80\uc0ac\ud569\ub2c8\ub2e4.");
        try {
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            if (cpa == null) {
                throw new EbmsCpaException(1, 0, "CPA\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            PartyInfo party = cpa.getPartyInfo(ebxmlMessage.getFrom());
            if (party == null) {
                throw new EbmsCpaException(1, 0, "Party\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            DeliveryChannel deliveryChannel = null;
            if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                String defaultMshChannelId = party.getDefaultMshChannelId();
                deliveryChannel = party.getDeliveryChannel(defaultMshChannelId);
            } else {
                deliveryChannel = party.getDeliveryChannelByAction(ebxmlMessage.getAction());
            }
            String duplicateElimination = deliveryChannel.getDuplicateElimination();
            log.info((Object)("DuplicateElimination => " + duplicateElimination));
            if (duplicateElimination.equals("always")) {
                log.info((Object)"DuplicateElimination => always\uc774\ubbc0\ub85c duplicateEliminaion\ub97c \ucd94\uac00 \ud569\ub2c8\ub2e4.");
                if (!ebxmlMessage.getEbxmlHeader().getMessageHeader().hasDuplicateElimination()) {
                    ebxmlMessage.getEbxmlHeader().getMessageHeader().addDuplicateElimenation();
                }
            }
            ebxmlMessage.saveChanges();
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "DuplicateElimination \uac80\uc0ac \uc5d0\ub7ec", e);
        }
    }

    private static void checkEbxmlMessageSign(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException {
        try {
            log.info((Object)"EbxmlMessage\ub97c Sign \ud574\uc57c\ud558\ub294\uc9c0 \uac80\uc0ac\ud569\ub2c8\ub2e4.");
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            if (cpa == null) {
                throw new EbmsCpaException(1, 0, "CPA\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            PartyInfo party = cpa.getPartyInfo(ebxmlMessage.getFrom());
            if (party == null) {
                throw new EbmsCpaException(1, 0, "Party\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            boolean isSign = party.getCanSend(ebxmlMessage.getAction()).getNonRepudiation();
            log.info((Object)("Sign ? " + isSign));
            if (isSign) {
                log.info((Object)"EbxmlMessage\uc5d0 Sign \ud569\ub2c8\ub2e4.");
                ebxmlMessage = new EbmsSignature().signEbxmlMessage(ebxmlMessage);
            }
        }
        catch (EbmsCpaException e) {
            throw new EbmsEbxmlMessageException(1, 0, "CPA\uc5d0 \ubb38\uc81c\uac00 \uc788\uc5b4 Sign\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.", e);
        }
        catch (EbmsSignException e) {
            throw new EbmsEbxmlMessageException(1, 0, "Sign\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.", e);
        }
        catch (EbmsKeyStoreException e) {
            throw new EbmsEbxmlMessageException(1, 0, "KeyStore\uc5d0 \ubb38\uc81c\uac00 \uc788\uc5b4 Sign\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.", e);
        }
    }
}

