/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.kldp.ebmsh.message.util.SOAPConstants;

public class ByteArrayDataSource
implements DataSource,
Serializable {
    private byte[] _data;
    private File _file;
    private String _type;
    private byte _fileFirstByte;
    private boolean _bCreatedTmpFile;
    private InputStream _lastFileInputStream;
    private String _soapAction;
    private String _encoding;
    private boolean _bEncryptedData;
    private boolean _bSignedData;
    private boolean _bSSLData;
    private boolean _bEncapsulatedMsg;

    public ByteArrayDataSource(String type) {
        this._type = type;
    }

    public ByteArrayDataSource(File ff, String type) throws IOException {
        if (ff == null || !ff.exists() || !ff.isFile()) {
            throw new IOException("File Not Found: " + ff);
        }
        this._file = ff;
        this._type = type;
        if (this._type == null) {
            this._type = FileTypeMap.getDefaultFileTypeMap().getContentType(ff);
        }
    }

    public ByteArrayDataSource(InputStream is, String type, int streamToTmpDiskSize) throws IOException {
        this._type = type;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileOutputStream out = null;
        try {
            int len;
            boolean bStreamToDisk = streamToTmpDiskSize > 0;
            int count = streamToTmpDiskSize;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                if (out == null) {
                    bos.write(buf, 0, len);
                    if (!bStreamToDisk || (count -= len) >= 0) continue;
                    this._bCreatedTmpFile = true;
                    this._file = File.createTempFile("ebxml-", null, null);
                    out = new FileOutputStream(this._file);
                    byte[] tmp = bos.toByteArray();
                    this._fileFirstByte = tmp[0];
                    out.write(tmp);
                    continue;
                }
                out.write(buf, 0, len);
            }
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            } else {
                this._data = bos.toByteArray();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            bos.close();
        }
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this._type = type;
        this._data = data;
    }

    public ByteArrayDataSource(String data, String type) {
        try {
            this._type = type;
            this._data = data.getBytes(ByteArrayDataSource.getEncoding(this._type, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void destroy() {
        if (this._file != null) {
            if (this._lastFileInputStream != null) {
                try {
                    this._lastFileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._bCreatedTmpFile) {
                this._file.delete();
            }
        }
    }

    private byte[] readInputStreamIntoBytes(InputStream is, boolean bCloseStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                bos.write(buf, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (bCloseStream) {
                is.close();
            }
            bos.close();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this._data != null) {
            return new ByteArrayInputStream(this._data);
        }
        if (this._file != null) {
            this._lastFileInputStream = new FileInputStream(this._file);
            return this._lastFileInputStream;
        }
        throw new IOException("No data.");
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(this._file == null);
    }

    public OutputStream getOutputStream(boolean bStoreAsBytesData) throws IOException {
        OutputStream out = null;
        if (bStoreAsBytesData) {
            out = new ByteArrayOutputStream();
            if (this._data != null) {
                out.write(this._data);
            }
        } else if (this._file == null) {
            this._bCreatedTmpFile = true;
            this._file = File.createTempFile("ebxml-", null, null);
            out = new FileOutputStream(this._file);
        } else {
            out = new FileOutputStream(this._file.getCanonicalPath(), true);
        }
        return out;
    }

    public void doneWithOutputStream(OutputStream out) throws IOException {
        if (out != null) {
            out.flush();
            out.close();
            if (out instanceof ByteArrayOutputStream) {
                this._data = ((ByteArrayOutputStream)out).toByteArray();
            }
        }
    }

    public String getContentType() {
        return this._type;
    }

    public void setContentType(String type) {
        this._type = type;
    }

    public String getSoapAction() {
        return this._soapAction;
    }

    public void setSoapAction(String soapAction) {
        this._soapAction = soapAction;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public boolean isEncryptedData() {
        return this._bEncryptedData;
    }

    public void setEncryptedData(boolean bEncryptedData) {
        this._bEncryptedData = bEncryptedData;
    }

    public boolean isEncapsulatedMsg() {
        return this._bEncapsulatedMsg;
    }

    public void setEncapsulatedMsg(boolean bEncapsulatedMsg) {
        this._bEncapsulatedMsg = bEncapsulatedMsg;
    }

    public boolean isSignedData() {
        return this._bSignedData;
    }

    public void setSignedData(boolean bSignedData) {
        this._bSignedData = bSignedData;
    }

    public boolean isSSLData() {
        return this._bSSLData;
    }

    public void setSSLData(boolean bSSL) {
        this._bSSLData = bSSL;
    }

    public String getName() {
        if (this._file != null) {
            return this._file.getName();
        }
        return "";
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this._data != null) {
            os.write(this._data);
        } else if (this._file != null) {
            FileInputStream is = new FileInputStream(this._file);
            try {
                int len;
                byte[] buf = new byte[4096];
                while ((len = ((InputStream)is).read(buf)) >= 0) {
                    os.write(buf, 0, len);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    public void headerWriteTo(OutputStream os) throws IOException {
        if (this._type != null) {
            os.write("Content-Type".getBytes());
            os.write(58);
            os.write(32);
            os.write(this._type.getBytes());
            os.write(SOAPConstants.CR.getBytes());
        }
        if (this._encoding != null) {
            os.write("Content-Transfer-Encoding".getBytes());
            os.write(58);
            os.write(32);
            os.write(this._encoding.getBytes());
            os.write(SOAPConstants.CR.getBytes());
        }
        if (this._soapAction != null) {
            os.write("SOAPAction".getBytes());
            os.write(58);
            os.write(32);
            os.write(this._soapAction.getBytes());
            os.write(SOAPConstants.CR.getBytes());
        }
    }

    public byte[] toByteArray() throws IOException {
        if (this._data == null && this._file != null) {
            FileInputStream is = new FileInputStream(this._file);
            this._data = this.readInputStreamIntoBytes(is, true);
        }
        return this._data;
    }

    public byte[] toByteArrayTrim() throws IOException {
        try {
            String content = this.getText();
            if (content != null) {
                return content.trim().getBytes(ByteArrayDataSource.getEncoding(this._type, "iso-8859-1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this._data;
    }

    public boolean isFirstByteLF() {
        if (this._data != null && this._data.length > 0) {
            return this._data[0] == 10 || this._data[0] == 13;
        }
        return this._fileFirstByte == 10 || this._fileFirstByte == 13;
    }

    public int getSize() {
        if (this._data != null) {
            return this._data.length;
        }
        if (this._file != null) {
            return (int)this._file.length();
        }
        return -1;
    }

    public String getText() throws IOException {
        if (this._data == null) {
            this.toByteArray();
        }
        if (this._data == null) {
            return null;
        }
        try {
            return new String(this._data, ByteArrayDataSource.getEncoding(this._type, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException uex) {
            try {
                return new String(this._data, "iso-8859-1");
            }
            catch (UnsupportedEncodingException uex1) {
                return null;
            }
        }
    }

    public static String getEncoding(String type, String defaultEncoding) {
        String encoding = null;
        try {
            if (type != null && !type.equals("")) {
                encoding = new ContentType(type).getParameter("charset");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        encoding = encoding == null ? defaultEncoding : MimeUtility.javaCharset((String)encoding);
        return encoding;
    }
}

