/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.transport.rm;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.cpa.Cpa;
import org.kldp.ebmsh.cpa.CpaManagerFactory;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.kldp.ebmsh.cpa.PartyInfo;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.transport.EbmsTransportException;
import org.kldp.ebmsh.message.transport.rm.AckRequestSender;
import org.kldp.ebmsh.message.transport.rm.RMManager;

public class RMSender {
    private static final Log log = LogFactory.getLog(RMSender.class);

    public void sendMessage(EbxmlMessage ebxmlMessage) throws EbmsTransportException {
        try {
            RMManager rmManager = RMManager.getInstance();
            String from = ebxmlMessage.getFrom();
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo fromPartyInfo = cpa.getPartyInfo(from);
            int maxRetryCount = fromPartyInfo.getReliableMessagebySenderUnderDocExchange(ebxmlMessage.getAction()).getRetries();
            int retryInterval = fromPartyInfo.getReliableMessagebySenderUnderDocExchange(ebxmlMessage.getAction()).getRertryInterval().getSecond();
            long retryIntervalLong = (long)retryInterval * 1000L;
            AckRequestSender ackRequestSender = new AckRequestSender(ebxmlMessage, maxRetryCount);
            rmManager.addAckRequestMessage(ebxmlMessage.getMessageId(), ackRequestSender);
            this.addEbxmlMessageAtScheduler(ackRequestSender, retryIntervalLong);
        }
        catch (EbmsCpaException e) {
            throw new EbmsTransportException(1, 0, e);
        }
    }

    private void addEbxmlMessageAtScheduler(AckRequestSender ackRequestSender, long retryInterval) {
        Timer jobScheduler = new Timer(true);
        jobScheduler.scheduleAtFixedRate((TimerTask)ackRequestSender, 0L, retryInterval);
    }
}

