/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.transport.rm;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.transport.EbxmlMessageSender;
import org.kldp.ebmsh.message.transport.rm.RMManager;

class AckRequestSender
extends TimerTask {
    private static Log log = LogFactory.getLog(AckRequestSender.class);
    private EbxmlMessage ebxmlMessage;
    private int nowRetryCount;
    private int maxRetryCount;

    public AckRequestSender(EbxmlMessage ebxmlMessage, int maxRetryCount) {
        this.ebxmlMessage = ebxmlMessage;
        this.nowRetryCount = -1;
        this.maxRetryCount = maxRetryCount;
    }

    public void run() {
        try {
            if (this.nowRetryCount < this.maxRetryCount) {
                ++this.nowRetryCount;
                log.info((Object)"RM \uba54\uc2dc\uc9c0 \uc804\uc1a1\ud569\ub2c8\ub2e4. ");
                log.info((Object)("Sending message id -> " + this.ebxmlMessage.getMessageId()));
                log.info((Object)("Now retry count -> " + this.nowRetryCount));
                new EbxmlMessageSender().sendMessageWithoutAction(this.ebxmlMessage);
                log.info((Object)"RM \uba54\uc2dc\uc9c0 \uc804\uc1a1 \uc885\ub8cc\ud569\ub2c8\ub2e4.");
                log.info((Object)(String.valueOf(this.ebxmlMessage.getMessageId()) + " sending ok.\n"));
            }
        }
        finally {
            if (this.nowRetryCount >= this.maxRetryCount) {
                log.info((Object)"Message sending failed");
                log.info((Object)("Message id -> " + this.ebxmlMessage.getMessageId()));
                RMManager.getInstance().removeAckRequestMessage(this.ebxmlMessage.getMessageId());
            }
        }
    }
}

