/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.processer.http;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.kldp.ebmsh.application.EbmsApplicationProcesserException;
import org.kldp.ebmsh.application.NonBlockingApplicationProcesser;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.impl.AcknowledgmentMessage;
import org.kldp.ebmsh.message.packaging.validation.EbmsEbxmlValidationException;
import org.kldp.ebmsh.message.persistant.MessageStatusConstraints;
import org.kldp.ebmsh.message.processer.EbmsMessageProcesserException;
import org.kldp.ebmsh.message.processer.MessageProcesser;
import org.kldp.ebmsh.message.transport.EbmsTransportException;
import org.kldp.ebmsh.message.transport.EbxmlMessageSender;
import org.kldp.ebmsh.message.util.MessageBuilderUtil;
import org.kldp.ebmsh.message.util.MessageUtil;

public class SyncMessageProcesser
extends MessageProcesser {
    private HttpServletResponse response;

    public void process(EbxmlMessage ebxmlMessage, HttpServletResponse response) {
        this.response = response;
        this.ebXMLMessageProcess(ebxmlMessage);
    }

    protected boolean AckRequested(EbxmlMessage ebxmlMessage) throws EbmsMessageProcesserException {
        log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4.");
        log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4.");
        AcknowledgmentMessage ackMessage = MessageBuilderUtil.buildAcknowledgmentMessage(ebxmlMessage);
        log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4.");
        EbxmlMessageSender sender = new EbxmlMessageSender();
        sender.sendMessageRedirect(ackMessage, this.response);
        return true;
    }

    protected boolean DuplicateElimination(EbxmlMessage ebxmlMessage) throws EbmsMessageProcesserException {
        log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0\uc778\uc9c0 \uac80\uc0ac\ud569\ub2c8\ub2e4.");
        if (this.persistantStorage.isDuplicated(ebxmlMessage)) {
            log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0 \uc785\ub2c8\ub2e4. \uba54\uc2dc\uc9c0 \ucc98\ub9ac\ub97c \uc911\uc9c0 \ud569\ub2c8\ub2e4.");
            this.flushBuffer(this.response, 200);
            this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.Success, "");
            return false;
        }
        log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0\uac00 \uc544\ub2d9\ub2c8\ub2e4.");
        log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0 \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4.");
        this.persistantStorage.saveDuplicateMessage(ebxmlMessage);
        this.flushBuffer(this.response, 200);
        return true;
    }

    protected boolean DuplicateElimination_AckRequested(EbxmlMessage ebxmlMessage) throws EbmsMessageProcesserException {
        log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0\uc778\uc9c0 \uac80\uc0ac\ud569\ub2c8\ub2e4.");
        if (this.persistantStorage.isDuplicated(ebxmlMessage)) {
            log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0 \uc785\ub2c8\ub2e4.");
            log.info((Object)"PersistantStore\ub85c\ubd80\ud130 Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \ubcf5\uc6d0\ud569\ub2c8\ub2e4.");
            EbxmlMessage ackMessage = this.persistantStorage.getAckMessage(ebxmlMessage.getMessageId());
            log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4.");
            EbxmlMessageSender sender = new EbxmlMessageSender();
            sender.sendMessageRedirect(ackMessage, this.response);
            this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.Success, "");
            return false;
        }
        log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0\uac00 \uc544\ub2d9\ub2c8\ub2e4.");
        log.info((Object)"\uc911\ubcf5 \uba54\uc2dc\uc9c0 \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4.");
        this.persistantStorage.saveDuplicateMessage(ebxmlMessage);
        log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4.");
        AcknowledgmentMessage ackMessage = MessageBuilderUtil.buildAcknowledgmentMessage(ebxmlMessage);
        log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0 \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4.");
        this.persistantStorage.saveAckMessageToFile(ackMessage);
        this.persistantStorage.saveAckMessageInfo(ackMessage);
        log.info((Object)"Acknowledgment ebXML \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4.");
        EbxmlMessageSender sender = new EbxmlMessageSender();
        sender.sendMessageRedirect(ackMessage, this.response);
        return true;
    }

    protected boolean Normal(EbxmlMessage ebxmlMessage) throws EbmsMessageProcesserException {
        this.flushBuffer(this.response, 200);
        return true;
    }

    protected EbxmlMessage applicationLevelMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        log.info((Object)"Non blocking application processer\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.");
        new NonBlockingApplicationProcesser().process(ebxmlMessage);
        return null;
    }

    protected void sendResponseEbxmlMessage(EbxmlMessage responseEbxmlMessage) throws EbmsTransportException {
        EbxmlMessageSender sender = new EbxmlMessageSender();
        if (MessageUtil.isSystemLevelActionMessage(responseEbxmlMessage)) {
            sender.sendMessageWithoutAction(responseEbxmlMessage);
        } else {
            sender.sendMessage(responseEbxmlMessage);
        }
    }

    protected void sendUndefinedErrorMessage(Exception e, EbxmlMessage errorEbxmlMessage) throws EbmsTransportException {
        EbxmlMessageSender sender = new EbxmlMessageSender();
        this.response.setStatus(500);
        sender.sendMessageRedirect(errorEbxmlMessage, this.response);
    }

    protected void sendValidationErrorMessage(EbmsEbxmlValidationException e, EbxmlMessage errorEbxmlMessage) throws EbmsTransportException {
        EbxmlMessageSender sender = new EbxmlMessageSender();
        this.response.setStatus(500);
        sender.sendMessageRedirect(errorEbxmlMessage, this.response);
    }

    private void flushBuffer(HttpServletResponse response, int responseCode) throws EbmsTransportException {
        try {
            log.info((Object)"Flushbuffer \uc2e4\ud589...");
            if (response != null && !response.isCommitted()) {
                response.setStatus(200);
                response.setContentLength(0);
                response.flushBuffer();
            }
        }
        catch (IOException e) {
            throw new EbmsTransportException(1, 0, "FlushBuffer \uc5d0\ub7ec", e);
        }
    }
}

