/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.processer;

import java.util.Date;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.EbmsException;
import org.kldp.ebmsh.application.EbmsApplicationProcesserException;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.impl.ErrorMessage;
import org.kldp.ebmsh.message.packaging.validation.EbmsEbxmlValidationException;
import org.kldp.ebmsh.message.packaging.validation.EbxmlMessageValidator;
import org.kldp.ebmsh.message.persistant.MessageStatusConstraints;
import org.kldp.ebmsh.message.persistant.PersistantStorage;
import org.kldp.ebmsh.message.processer.EbmsMessageProcesserException;
import org.kldp.ebmsh.message.transport.EbmsTransportException;
import org.kldp.ebmsh.message.transport.rm.AckReceiveNotifier;
import org.kldp.ebmsh.message.util.MessageBuilderUtil;
import org.kldp.ebmsh.message.util.MessageUtil;
import org.kldp.ebmsh.tracker.Tracker;
import org.kldp.util.log.LogUtil;

public abstract class MessageProcesser {
    protected static final Log log = LogFactory.getLog(MessageProcesser.class);
    protected PersistantStorage persistantStorage = new PersistantStorage();

    protected MessageProcesser() {
    }

    private int ebXMLMessageSort(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException {
        try {
            Tracker.tracking(ebxmlMessage.getMessageId(), new Date(), "\uba54\uc2dc\uc9c0 \ubd84\ub958\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", "");
            int statusCode = 0;
            if (ebxmlMessage.getEbxmlHeader().hasAckRequested()) {
                ++statusCode;
            }
            if (ebxmlMessage.getEbxmlHeader().getMessageHeader().hasDuplicateElimination()) {
                statusCode += 10;
            }
            if (ebxmlMessage.getEbxmlHeader().hasMessageOrder()) {
                statusCode += 100;
            }
            return statusCode;
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
    }

    protected void ebXMLMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsMessageProcesserException {
        log.info((Object)"Start MessageProcesser.");
        String messageId = null;
        try {
            messageId = ebxmlMessage.getMessageId();
            log.info((Object)" Save ebXML message to Incoming message store and File system.");
            this.persistantStorage.saveIncomingMessageDbAndFile(ebxmlMessage);
            Tracker.tracking(messageId, new Date(), "\uba54\uc2dc\uc9c0 \ud504\ub85c\uc138\uc11c\ub97c \uc2dc\uc791 \ud569\ub2c8\ub2e4.", "");
            log.info((Object)" Save status( Receive ) of ebXML message.");
            this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.Receive, "");
            try {
                log.info((Object)" Start ebXML message validation.");
                new EbxmlMessageValidator().validate(ebxmlMessage);
            }
            catch (EbmsEbxmlValidationException e) {
                log.fatal((Object)" [ Error ] - ebXML message validation fail.");
                log.fatal((Object)("  " + LogUtil.stackTraceToString((Throwable)e)));
                Tracker.tracking(messageId, new Date(), "\uba54\uc2dc\uc9c0 \uac80\uc99d \uc2e4\ud328.", e.getErrorString());
                this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.Fail, "");
                Tracker.tracking(messageId, new Date(), "\uc5d0\ub7ec \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4", "");
                log.fatal((Object)"  Creating error ebXML message.");
                EbxmlMessage errorEbxmlMessage = e.getEbxmlMessage(ebxmlMessage);
                log.fatal((Object)"  Send error ebXML message.");
                try {
                    this.sendValidationErrorMessage(e, errorEbxmlMessage);
                }
                catch (EbmsTransportException ex) {
                    log.fatal((Object)"   [ Error ] - Can't send error ebXML message.");
                    log.fatal((Object)("    " + LogUtil.stackTraceToString((Throwable)ex)));
                    Tracker.tracking(messageId, new Date(), "\uc5d0\ub7ec \uba54\uc2dc\uc9c0 \uc804\uc1a1\uc744 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", ex.getMessage());
                    throw ex;
                }
                throw e;
            }
            log.info((Object)" Save ebXML message to MessageStore.");
            this.persistantStorage.saveMessageStore(ebxmlMessage);
            log.info((Object)" Sort ebXML message.");
            int statusCode = this.ebXMLMessageSort(ebxmlMessage);
            log.info((Object)("  Sort result of ebXML message - " + statusCode));
            Tracker.tracking(ebxmlMessage.getMessageId(), new Date(), "StatusCode -> " + statusCode + " \ud504\ub85c\uc138\uc11c\ub97c \uc2e4\ud589\ud569\ub2c8\ub2e4.", "");
            boolean continueProcessapplicationLayer = false;
            switch (statusCode) {
                case 0: {
                    continueProcessapplicationLayer = this.Normal(ebxmlMessage);
                    break;
                }
                case 1: {
                    continueProcessapplicationLayer = this.AckRequested(ebxmlMessage);
                    break;
                }
                case 10: {
                    continueProcessapplicationLayer = this.DuplicateElimination(ebxmlMessage);
                    break;
                }
                case 11: {
                    continueProcessapplicationLayer = this.DuplicateElimination_AckRequested(ebxmlMessage);
                    break;
                }
                default: {
                    throw new EbmsMessageProcesserException(1, 0, "\ucc98\ub9ac\ud560 \uc218 \uc5c6\ub294 \uba54\uc2dc\uc9c0 \ud0c0\uc785\uc785\ub2c8\ub2e4.");
                }
            }
            if (continueProcessapplicationLayer) {
                log.info((Object)"Application layer \ud504\ub85c\uc138\uc11c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.");
                Tracker.tracking(ebxmlMessage.getMessageId(), new Date(), "Application layer \ud504\ub85c\uc138\uc11c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", "");
                log.info((Object)"Save status( ApplicationLayerProcess ) of ebXML message.");
                this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.ApplicationLayerProcess, "");
                EbxmlMessage responseEbxmlMessage = null;
                if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                    String action = ebxmlMessage.getAction();
                    log.info((Object)("System level action \uba54\uc2dc\uc9c0 \uc785\ub2c8\ub2e4. Action -> " + action));
                    if (action.equals("Ping")) {
                        log.info((Object)"Ping \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4.");
                        responseEbxmlMessage = this.systemLevelPingMessageProcess(ebxmlMessage);
                    } else if (action.equals("Pong")) {
                        log.info((Object)"Pong \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4.");
                        responseEbxmlMessage = this.systemLevelPongMessageProcess(ebxmlMessage);
                    } else if (action.equals("MessageStatusRequest")) {
                        log.info((Object)"MessageStatusRequest \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4.");
                        log.error((Object)"MessageStatusRequest\ub294 \uad6c\ud604\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
                    } else if (action.equals("MessageStatusResponse")) {
                        log.info((Object)"MessageStatusResponse \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4.");
                        responseEbxmlMessage = this.systemLevelMessageStatusResponseMessageProcess(ebxmlMessage);
                    } else if (action.equals("Acknowledgment")) {
                        log.info((Object)"Acknowledgment \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4.");
                        responseEbxmlMessage = this.systemLevelAcknowledgmentMessageProcess(ebxmlMessage);
                    } else if (action.equals("MessageError")) {
                        log.info((Object)"MessageError \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4.");
                        responseEbxmlMessage = this.systemLevelMessageErrorMessageProcess(ebxmlMessage);
                    }
                } else {
                    log.info((Object)(String.valueOf(ebxmlMessage.getAction()) + " \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud569\ub2c8\ub2e4."));
                    responseEbxmlMessage = this.applicationLevelMessageProcess(ebxmlMessage);
                }
                if (responseEbxmlMessage != null) {
                    log.info((Object)"\uc0c1\ub300 \ubc29\uc5d0\uac8c \uc751\ub2f5 \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4.");
                    this.sendResponseEbxmlMessage(responseEbxmlMessage);
                }
            }
            log.info((Object)"Save status( Success ) of ebXML message.");
            this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.Success, "");
            Tracker.tracking(ebxmlMessage.getMessageId(), new Date(), "\uba54\uc2dc\uc9c0 \ucc98\ub9ac\ub97c \uc885\ub8cc \ud569\ub2c8\ub2e4.", "");
        }
        catch (EbmsException e) {
            if (e instanceof EbmsEbxmlValidationException) {
                throw e;
            }
            EbmsMessageProcesserException exception = new EbmsMessageProcesserException(1, 0, e);
            log.fatal((Object)" [ Error ] - ebXML message process fail.");
            log.fatal((Object)("  " + LogUtil.stackTraceToString((Throwable)e)));
            Tracker.tracking(messageId, new Date(), "\uba54\uc2dc\uc9c0 \ucc98\ub9ac\ub97c \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4", e.getMessage());
            log.fatal((Object)" Save status( Fail ) of ebXML message.");
            this.persistantStorage.saveMessageStatus(ebxmlMessage, MessageStatusConstraints.Fail, "");
            Tracker.tracking(messageId, new Date(), "\uc5d0\ub7ec \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4", "");
            try {
                log.fatal((Object)"  Creating error ebXML message.");
                ErrorMessage errMsg = MessageBuilderUtil.buildMessageErrorMessage(ebxmlMessage);
                errMsg.setError("urn:oasis:names:tc:ebxml-msg:service:errors", "Unknown", "Error", "Can't process message.", e.getMessage());
                log.fatal((Object)"  Send error ebXML message.");
                this.sendUndefinedErrorMessage(e, errMsg);
            }
            catch (EbmsTransportException ex) {
                log.fatal((Object)"   [ Error ] - Can't send error ebXML message.");
                log.fatal((Object)("    " + LogUtil.stackTraceToString((Throwable)ex)));
                Tracker.tracking(messageId, new Date(), "\uc5d0\ub7ec \uba54\uc2dc\uc9c0 \uc804\uc1a1\uc744 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", "");
                exception.initCause(ex);
            }
            catch (EbmsEbxmlMessageException ex) {
                log.fatal((Object)"   [ Error ] - Can't create error ebXML message.");
                log.fatal((Object)("    " + LogUtil.stackTraceToString((Throwable)ex)));
                Tracker.tracking(messageId, new Date(), "\uc5d0\ub7ec \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", "");
                exception.initCause(ex);
            }
            throw exception;
        }
    }

    protected EbxmlMessage systemLevelPingMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        try {
            log.info((Object)"Pong \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4.");
            EbxmlMessage pongMessage = MessageBuilderUtil.buildPongMessage(ebxmlMessage);
            return pongMessage;
        }
        catch (EbmsEbxmlMessageException e) {
            throw new EbmsApplicationProcesserException(1, 0, e);
        }
    }

    protected EbxmlMessage systemLevelPongMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        return null;
    }

    protected EbxmlMessage systemLevelMessageStatusRequestMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        return null;
    }

    protected EbxmlMessage systemLevelMessageStatusResponseMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        return null;
    }

    protected EbxmlMessage systemLevelAcknowledgmentMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        try {
            String refToMessageId = ebxmlMessage.getEbxmlHeader().getAcknowledgment().getRefToMessageId().getValue();
            AckReceiveNotifier.getInstance().receiveAck(refToMessageId);
        }
        catch (SOAPException e) {
            throw new EbmsApplicationProcesserException(1, 0, e);
        }
        return null;
    }

    protected EbxmlMessage systemLevelMessageErrorMessageProcess(EbxmlMessage ebxmlMessage) throws EbmsApplicationProcesserException {
        return null;
    }

    protected abstract EbxmlMessage applicationLevelMessageProcess(EbxmlMessage var1) throws EbmsApplicationProcesserException;

    protected abstract void sendUndefinedErrorMessage(Exception var1, EbxmlMessage var2) throws EbmsTransportException;

    protected abstract void sendResponseEbxmlMessage(EbxmlMessage var1) throws EbmsTransportException;

    protected abstract void sendValidationErrorMessage(EbmsEbxmlValidationException var1, EbxmlMessage var2) throws EbmsTransportException;

    protected abstract boolean Normal(EbxmlMessage var1) throws EbmsMessageProcesserException;

    protected abstract boolean AckRequested(EbxmlMessage var1) throws EbmsMessageProcesserException;

    protected abstract boolean DuplicateElimination(EbxmlMessage var1) throws EbmsMessageProcesserException;

    protected abstract boolean DuplicateElimination_AckRequested(EbxmlMessage var1) throws EbmsMessageProcesserException;
}

