/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.DbTemplate;
import org.kldp.ebmsh.message.persistant.DbWorker;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;
import org.kldp.ebmsh.message.persistant.IncomingMessage;

public class IncomingMessageDAO {
    private static final Log log = LogFactory.getLog(IncomingMessageDAO.class);

    public void insertIncomingMessage(EbxmlMessage ebxmlMessage, long receiveTime, String messageFilePath) throws EbmsPersistantException {
        log.info((Object)"DB\uc5d0 IncomingMessage \uc815\ubcf4\ub97c \uae30\ub85d \ud569\ub2c8\ub2e4");
        String messageId = ebxmlMessage.getMessageId();
        Timestamp receiveTimeTimestamp = new Timestamp(receiveTime);
        final String queryStr = "insert into " + EbmsConstants.bizboxDatabaseHeaderName + "InComingMessage(MessageId, ReceiveTime, MSGFilePath) values(?, ?, ?)";
        final Object[] parameters = new Object[]{messageId, receiveTimeTimestamp, messageFilePath};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public void updateIncomingMessage(EbxmlMessage ebxmlMessage, long receiveTime, String messageFilePath) throws EbmsPersistantException {
        String messageId = ebxmlMessage.getMessageId();
        Timestamp receiveTimeTimestamp = new Timestamp(receiveTime);
        final String queryStr = "update " + EbmsConstants.bizboxDatabaseHeaderName + "InComingMessage set ReceiveTime=?, MSGFilePath=? where MessageId=?";
        final Object[] parameters = new Object[]{receiveTimeTimestamp, messageFilePath, messageId};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    IncomingMessage getInComingMessage(String messageId) throws EbmsPersistantException {
        IncomingMessage inComingMessage = null;
        DbTemplate dbTemplate = new DbTemplate();
        final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "InComingMessage where MessageId=?";
        final Object[] params = new Object[]{messageId};
        inComingMessage = (IncomingMessage)dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                BeanHandler resultSetHandler = new BeanHandler(IncomingMessage.class);
                IncomingMessage queryResult = null;
                try {
                    queryResult = (IncomingMessage)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(0, e.getErrorCode(), e);
                }
                return queryResult;
            }
        });
        return inComingMessage;
    }
}

