/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.cpa;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CertificateDocument;
import org.w3.x2000.x09.xmldsig.X509DataType;

public class Certificate {
    CertificateDocument.Certificate certificate = null;

    public Certificate(CertificateDocument.Certificate _certificate) {
        this.certificate = _certificate;
    }

    public String getCertId() throws EbmsCpaException {
        try {
            return this.certificate.getCertId();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getKeyNames() throws EbmsCpaException {
        try {
            return this.certificate.getKeyInfo().getKeyNameArray();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public X509Certificate[] getX509Certificate() throws EbmsCpaException {
        try {
            X509Certificate[] x509Certificate = null;
            if (this.certificate.getKeyInfo().getX509DataArray().length != 0) {
                x509Certificate = new X509Certificate[this.certificate.getKeyInfo().getX509DataArray().length];
                int i = 0;
                while (i < this.certificate.getKeyInfo().getX509DataArray().length) {
                    ByteArrayInputStream inStream = new ByteArrayInputStream(this.certificate.getKeyInfo().getX509DataArray(i).getX509CertificateArray(i));
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x509Certificate[i] = (X509Certificate)cf.generateCertificate(inStream);
                    ++i;
                }
            }
            return x509Certificate;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setCertId(String _certId) throws EbmsCpaException {
        try {
            this.certificate.setCertId(_certId);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setKeyName(int _seq, String _keyName) throws EbmsCpaException {
        try {
            this.certificate.getKeyInfo().setKeyNameArray(_seq, _keyName);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setX509Certificate(int _seq, String _certificate) throws EbmsCpaException {
        try {
            X509DataType dataType = X509DataType.Factory.newInstance();
            dataType.setX509CertificateArray(_seq, _certificate.getBytes());
            this.certificate.addNewKeyInfo();
            this.certificate.getKeyInfo().setX509DataArray(_seq, dataType);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }
}

