/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.application;

import java.io.IOException;
import java.io.InputStream;
import org.kldp.ebmsh.application.BlockingApplicationProcesserManager;
import org.kldp.ebmsh.application.EbmsApplicationProcesserException;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.queue.EbmsQueueException;
import org.kldp.ebmsh.queue.QueueHelper;
import org.kldp.ebmsh.queue.ToApplicationMessage;
import org.kldp.ebmsh.queue.ToApplicationMessageConverter;
import org.kldp.ebmsh.queue.ToApplicationQueueManager;

public class BlockingApplicationProcesser {
    private EbxmlMessage resultEbxmlMessage;

    public EbxmlMessage process(EbxmlMessage _ebxmlMessage) throws EbmsApplicationProcesserException {
        try {
            long uid = System.currentTimeMillis();
            ToApplicationMessage applicationMessage = new ToApplicationMessage();
            applicationMessage.setUid(uid);
            applicationMessage.setMessageId(_ebxmlMessage.getMessageId());
            applicationMessage.setCpaId(_ebxmlMessage.getCPAId());
            applicationMessage.setFrom(_ebxmlMessage.getFrom());
            applicationMessage.setTo(_ebxmlMessage.getTo());
            applicationMessage.setConversationId(_ebxmlMessage.getConversationId());
            applicationMessage.setAction(_ebxmlMessage.getAction());
            applicationMessage.setService(_ebxmlMessage.getService());
            applicationMessage.setTimestamp(_ebxmlMessage.getTimestamp());
            applicationMessage.setBlock(false);
            int payloadCount = _ebxmlMessage.countAttachments();
            if (payloadCount != 0) {
                byte[][] payloads = new byte[payloadCount][0];
                try {
                    int i = 0;
                    while (i < payloadCount) {
                        InputStream inputStream = _ebxmlMessage.getPayload(i + 1).getInputStream();
                        StringBuffer sb = new StringBuffer();
                        byte[] tmp = new byte[inputStream.available()];
                        inputStream.read(tmp);
                        sb.append(new String(tmp).toCharArray());
                        payloads[i] = sb.toString().getBytes();
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new EbmsEbxmlMessageException(1, 0, "Payload\ub97c \uaebc\ub0bc\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
                applicationMessage.setPayloadCount(payloadCount);
                applicationMessage.setPayloads(payloads);
            } else {
                applicationMessage.setPayloadCount(0);
            }
            QueueHelper queueHelper = ToApplicationQueueManager.getInstance().getToApplicationQueueHelper(String.valueOf(EbmsConstants.queueJNDIHeaderName) + _ebxmlMessage.getAction());
            queueHelper.sendMessage(applicationMessage, new ToApplicationMessageConverter());
            BlockingApplicationProcesserManager.getInstance().registerBlockingApplicationProcesser(uid, this);
            this.wait();
            return this.resultEbxmlMessage;
        }
        catch (InterruptedException e) {
            throw new EbmsApplicationProcesserException(0, 0, e);
        }
        catch (EbmsEbxmlMessageException e) {
            throw new EbmsApplicationProcesserException(0, 0, e);
        }
        catch (EbmsQueueException e) {
            throw new EbmsApplicationProcesserException(0, 0, e);
        }
    }

    public void processNotify(EbxmlMessage ebxmlMessage) {
        this.resultEbxmlMessage = ebxmlMessage;
    }
}

