/*
 * Decompiled with CFR 0.152.
 */
package com.softmeca.security.keystore;

import com.softmeca.security.keystore.IKeyStoreHandler;
import com.softmeca.util.io.FileIoUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.security.tools.KeyTool;

public class JKSKeyStoreHandler
extends IKeyStoreHandler {
    private static Log log;
    private String keyStorePath = null;
    private String csrPath = null;
    private String keyStorePassword = null;
    private KeyStore keyStore = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.softmeca.security.keystore.JKSKeyStoreHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private JKSKeyStoreHandler() {
    }

    public JKSKeyStoreHandler(String _keyStoreFilePath, String _keyStorePassword, String _csrPath) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        this.keyStorePath = _keyStoreFilePath;
        this.keyStorePassword = _keyStorePassword;
        this.csrPath = _csrPath;
        if (!FileIoUtil.hasFile((String)_keyStoreFilePath)) {
            throw new KeyStoreException("KeyStore\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uacbd\ub85c: " + _keyStoreFilePath);
        }
        if (!FileIoUtil.hasDirectory((String)_csrPath)) {
            throw new KeyStoreException("Csr path\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uacbd\ub85c: " + _csrPath);
        }
        this.initKeyStore();
    }

    protected void initKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        try {
            this.keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStoreFileInputStream = new FileInputStream(this.keyStorePath);
            this.keyStore.load(keyStoreFileInputStream, this.keyStorePassword.toCharArray());
        }
        catch (IOException e) {
            IOException ioe = new IOException("Keystore \ucd08\uae30\ud654 \uc2e4\ud328");
            ioe.initCause(e);
            throw ioe;
        }
        catch (CertificateException e) {
            CertificateException ce = new CertificateException();
            ce.initCause(e);
            throw ce;
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException();
            nsae.initCause(e);
            throw nsae;
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
    }

    public void saveKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream keyStoreFileOutputStream = null;
        try {
            keyStoreFileOutputStream = new FileOutputStream(this.keyStorePath);
            this.keyStore.store(keyStoreFileOutputStream, this.keyStorePassword.toCharArray());
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException();
            nsae.initCause(e);
            throw nsae;
        }
        catch (CertificateException e) {
            CertificateException ce = new CertificateException();
            ce.initCause(e);
            throw ce;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Keystore \ucd08\uae30\ud654 \uc2e4\ud328");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void generateKeyPair(String _algorithm, int _size, String _alias, String _password, String _cnName) {
        String[] str = new String[]{"-genkey", "-keyalg", _algorithm, "-keysize", String.valueOf(_size), "-alias", _alias, "-keypass", _password, "-keystore", this.keyStorePath, "-storepass", this.keyStorePassword, "-dname", "cn=" + _cnName};
        KeyTool.main((String[])str);
        try {
            this.initKeyStore();
        }
        catch (IOException e) {
            IOException ioe = new IOException("Keystore \ucd08\uae30\ud654 \uc2e4\ud328");
            ioe.initCause(e);
            log.fatal((Object)ioe);
        }
        catch (CertificateException e) {
            CertificateException ce = new CertificateException();
            ce.initCause(e);
            log.fatal((Object)ce);
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException();
            nsae.initCause(e);
            log.fatal((Object)nsae);
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            log.fatal((Object)kse);
        }
    }

    public String generateCSR(String _alias) throws IOException {
        String csrData = null;
        String[] str = new String[]{"-certreq", "-alias", _alias, "-keystore", this.keyStorePath, "-storepass", this.keyStorePassword, "-file", String.valueOf(this.csrPath) + _alias + ".csr"};
        KeyTool.main((String[])str);
        csrData = FileIoUtil.readDataFromFile((String)(String.valueOf(this.csrPath) + _alias + ".csr"));
        return csrData;
    }

    public Certificate getCertificate(String _alias) throws KeyStoreException {
        Certificate certificate = null;
        try {
            certificate = this.keyStore.getCertificate(_alias);
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        return certificate;
    }

    public PrivateKey getPrivateKey(String _alias, String _password) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)this.keyStore.getKey(_alias, _password.toCharArray());
            if (privateKey == null) {
                throw new KeyStoreException("alias\uc5d0 \ud574\ub2f9\ud558\ub294 \ud0a4\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4. alias->" + _alias);
            }
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException();
            nsae.initCause(e);
            throw nsae;
        }
        catch (UnrecoverableKeyException e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException();
            uke.initCause(e);
            throw uke;
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        return privateKey;
    }

    public void importCertificate(String _alias, String _keyPassword, Certificate _certificate) throws UnrecoverableKeyException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        try {
            PrivateKey key = this.getPrivateKey(_alias, _keyPassword);
            this.keyStore.setKeyEntry(_alias, key, _keyPassword.toCharArray(), new Certificate[]{_certificate});
            this.saveKeyStore();
        }
        catch (UnrecoverableKeyException e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException();
            uke.initCause(e);
            throw uke;
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        catch (CertificateException e) {
            CertificateException ce = new CertificateException();
            ce.initCause(e);
            throw ce;
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException();
            nsae.initCause(e);
            throw nsae;
        }
        catch (IOException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void importTrustCertificate(String _alias, Certificate _certificate) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        try {
            this.keyStore.setCertificateEntry(_alias, _certificate);
            this.saveKeyStore();
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        catch (CertificateException e) {
            CertificateException ce = new CertificateException();
            ce.initCause(e);
            throw ce;
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException();
            nsae.initCause(e);
            throw nsae;
        }
        catch (IOException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public boolean hasAlias(String _alias) throws KeyStoreException {
        boolean result = false;
        try {
            result = this.keyStore.containsAlias(_alias);
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        return result;
    }

    public ArrayList getAllEntryAlias() throws KeyStoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<String> _enum = this.keyStore.aliases();
            while (_enum.hasMoreElements()) {
                String str = _enum.nextElement();
                arrayList.add(str);
            }
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
        return arrayList;
    }

    public void deleteEntry(String _alias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        try {
            this.keyStore.deleteEntry(_alias);
            this.saveKeyStore();
        }
        catch (KeyStoreException e) {
            KeyStoreException kse = new KeyStoreException();
            kse.initCause(e);
            throw kse;
        }
    }
}

