/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.tracker;

import java.util.Date;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.bi.environment.EbbiConstants;
import org.kldp.ebmsh.bi.queue.QueueHelper;
import org.kldp.ebmsh.bi.queue.TrackerMessage;
import org.kldp.ebmsh.bi.queue.TrackerMessageConverter;
import org.kldp.ebmsh.bi.tracker.BiTrackerException;
import org.kldp.util.j2ee.resource.QueueConnectionFactoryServiceLocator;
import org.kldp.util.j2ee.resource.QueueServiceLocator;

public class Tracker {
    private static final Log log = LogFactory.getLog(Tracker.class);
    private static boolean isInited;
    private static QueueHelper queueHelper;

    private Tracker() {
    }

    private static void init() throws BiTrackerException {
        try {
            QueueServiceLocator queueResource = QueueServiceLocator.getInstance();
            QueueConnectionFactoryServiceLocator queueConnectionFactoryResource = QueueConnectionFactoryServiceLocator.getInstance();
            QueueConnectionFactory queueConnectionFactory = queueConnectionFactoryResource.getQueueConnectionFactory(EbbiConstants.queueConnectionFactoryName);
            Queue queue = queueResource.getQueue(String.valueOf(EbbiConstants.queueJNDIHeaderName) + EbbiConstants.trackerQueueName);
            queueHelper = new QueueHelper(queueConnectionFactory, queue);
        }
        catch (NamingException e) {
            throw new BiTrackerException(1, 0, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tracking(String messageId, Date timestamp, String state, String information) {
        Class<Tracker> clazz = Tracker.class;
        synchronized (Tracker.class) {
            if (!isInited) {
                Tracker.init();
                isInited = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (information == null) {
                information = "";
            }
            TrackerMessage trackerMessage = new TrackerMessage();
            trackerMessage.setMessageId(messageId);
            trackerMessage.setTimestamp(timestamp);
            trackerMessage.setState(state);
            trackerMessage.setInformation(information);
            queueHelper.sendMessage(trackerMessage, new TrackerMessageConverter());
            return;
        }
    }
}

