/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.queue;

import java.util.Date;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.QueueSession;
import org.kldp.ebmsh.bi.queue.BiQueueMessageException;
import org.kldp.ebmsh.bi.queue.MessageConverter;
import org.kldp.ebmsh.bi.queue.QueueMessage;
import org.kldp.ebmsh.bi.queue.TrackerMessage;

public class TrackerMessageConverter
implements MessageConverter {
    public QueueMessage convertToQueueMessage(Message message) throws BiQueueMessageException {
        TrackerMessage trackerMessage = null;
        this.validateMessage(message);
        try {
            trackerMessage = new TrackerMessage();
            MapMessage mapMessage = (MapMessage)message;
            trackerMessage.setMessageId(mapMessage.getString("messageId"));
            Date date = new Date(mapMessage.getLong("timestamp"));
            trackerMessage.setTimestamp(date);
            trackerMessage.setState(mapMessage.getString("state"));
            trackerMessage.setInformation(mapMessage.getString("information"));
        }
        catch (JMSException e) {
            throw new BiQueueMessageException(0, 0, e);
        }
        return trackerMessage;
    }

    public Message convertToJMSMessage(QueueSession queueSession, QueueMessage queueMessage) throws BiQueueMessageException {
        MapMessage mapMessage = null;
        TrackerMessage trackerMessage = (TrackerMessage)queueMessage;
        this.validateMessage(trackerMessage);
        try {
            mapMessage = queueSession.createMapMessage();
            mapMessage.setString("messageId", trackerMessage.getMessageId());
            mapMessage.setLong("timestamp", trackerMessage.getTimestamp().getTime());
            mapMessage.setString("state", trackerMessage.getState());
            mapMessage.setString("information", trackerMessage.getInformation());
        }
        catch (JMSException e) {
            throw new BiQueueMessageException(0, 0, e);
        }
        return mapMessage;
    }

    public void validateMessage(Message message) throws BiQueueMessageException {
        try {
            if (message == null) {
                throw new IllegalArgumentException("Message\uac00 null\uc785\ub2c8\ub2e4.");
            }
            if (!(message instanceof MapMessage)) {
                throw new IllegalArgumentException("Message \ud0c0\uc785\uc774 MapMessage\uac00 \uc544\ub2d9\ub2c8\ub2e4.");
            }
            MapMessage _mapMessage = (MapMessage)message;
            if (!_mapMessage.itemExists("messageId")) {
                throw new IllegalArgumentException("MapMessage\uc5d0 MessageId \uc544\uc774\ud15c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("timestamp")) {
                throw new IllegalArgumentException("MapMessage\uc5d0 Timestamp \uc544\uc774\ud15c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("state")) {
                throw new IllegalArgumentException("MapMessage\uc5d0 State \uc544\uc774\ud15c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            if (!_mapMessage.itemExists("information")) {
                throw new IllegalArgumentException("MapMessage\uc5d0 Information \uc544\uc774\ud15c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (IllegalArgumentException e) {
            throw new BiQueueMessageException(0, 0, e);
        }
        catch (JMSException e) {
            throw new BiQueueMessageException(0, 0, e);
        }
    }

    public void validateMessage(QueueMessage queueMessage) throws BiQueueMessageException {
        try {
            if (queueMessage == null) {
                throw new IllegalArgumentException("TrackerMessage\uac00 null\uc785\ub2c8\ub2e4.");
            }
        }
        catch (IllegalArgumentException e) {
            throw new BiQueueMessageException(0, 0, e);
        }
    }
}

