/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.processer;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.ByteArrayInputStream;
import java.util.Date;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.kldp.ebmsh.bi.environment.EbbiConstants;
import org.kldp.ebmsh.bi.persistant.BiDatabaseManager;
import org.kldp.ebmsh.bi.persistant.BiMessageStatus;
import org.kldp.ebmsh.bi.persistant.DocumentIdInfo;
import org.kldp.ebmsh.bi.processer.BiUserProcesserException;
import org.kldp.ebmsh.bi.processer.BiUserProcesserResult;
import org.kldp.ebmsh.bi.queue.ApplicationResultMessage;
import org.kldp.ebmsh.bi.queue.ApplicationResultMessageConverter;
import org.kldp.ebmsh.bi.queue.QueueHelper;
import org.kldp.ebmsh.bi.queue.ToApplicationMessage;
import org.kldp.ebmsh.bi.queue.ToApplicationMessageConverter;
import org.kldp.ebmsh.bi.tracker.Tracker;
import org.kldp.util.j2ee.resource.QueueConnectionFactoryServiceLocator;
import org.kldp.util.j2ee.resource.QueueServiceLocator;
import org.kldp.util.log.LogUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class BiProcesser {
    private static Log log = LogFactory.getLog(BiProcesser.class);

    public void process(Message message) {
        QueueConnectionFactory queueConnectionFactory = null;
        Queue applicationResultQueue = null;
        BiDatabaseManager bsiDatabaseManager = null;
        BiUserProcesserResult bsiUserProcesserResult = null;
        ToApplicationMessage toApplicationMessage = null;
        log.info((Object)"JMS \uba54\uc2dc\uc9c0\ub97c ToApplicationMessage\ub85c \ubcc0\ud658\ud569\ub2c8\ub2e4.");
        toApplicationMessage = (ToApplicationMessage)new ToApplicationMessageConverter().convertToQueueMessage(message);
        try {
            try {
                Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "Business logic\uc744 \uc2dc\uc791 \ud569\ub2c8\ub2e4", "");
                queueConnectionFactory = QueueConnectionFactoryServiceLocator.getInstance().getQueueConnectionFactory(EbbiConstants.queueConnectionFactoryName);
                applicationResultQueue = QueueServiceLocator.getInstance().getQueue(String.valueOf(EbbiConstants.queueJNDIHeaderName) + EbbiConstants.applicationResultQueueName);
                bsiDatabaseManager = new BiDatabaseManager();
                log.info((Object)"\uba54\uc2dc\uc9c0 \uc0c1\ud0dc\ub97c Receive\ub85c \ubcc0\uacbd\ud569\ub2c8\ub2e4.");
                bsiDatabaseManager.saveMessageStatus(toApplicationMessage.getMessageId(), BiMessageStatus.Receive, "");
                Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "\ubb38\uc11c\uc5d0\uc11c DocumentId\ub97c \uac00\uc838\uc635\ub2c8\ub2e4", "");
                log.info((Object)"DB\uc5d0\uc11c DocumentId \uc815\ubcf4\ub97c \uac00\uc838\uc635\ub2c8\ub2e4.");
                DocumentIdInfo documentIdInfo = bsiDatabaseManager.getDocumentIdInfoByAction(toApplicationMessage.getAction());
                if (documentIdInfo != null) {
                    int payloadIndex = documentIdInfo.getPayloadIndex();
                    String xPath = documentIdInfo.getXPath();
                    log.info((Object)("DocumentId \uc815\ubcf4 -> PayloadIndex: " + payloadIndex + "\tXPath: " + xPath));
                    byte[] payload = toApplicationMessage.getPayloads()[payloadIndex - 1];
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(payload);
                    DOMParser parser = new DOMParser();
                    parser.parse(new InputSource(inputStream));
                    Document document = parser.getDocument();
                    String documentId = XPathAPI.selectSingleNode(document.getFirstChild(), xPath).getFirstChild().getNodeValue();
                    log.info((Object)"DB\uc5d0 DocumentId\uc640 MessageId mapping \uc815\ubcf4\ub97c \uc785\ub825\ud569\ub2c8\ub2e4.");
                    bsiDatabaseManager.saveMessageIdAndDocumentId(toApplicationMessage.getMessageId(), documentId);
                } else {
                    log.info((Object)"DB\uc5d0 DocumentId \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                log.info((Object)"User\uac00 \uad6c\ud604\ud55c processer\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.");
                Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "UserProcess\ub97c \uc2dc\uc791 \ud569\ub2c8\ub2e4", "");
                bsiUserProcesserResult = this.userProcesser(toApplicationMessage);
                log.info((Object)"\uba54\uc2dc\uc9c0 \uc0c1\ud0dc\ub97c Sucess\ub85c \ubcc0\uacbd\ud569\ub2c8\ub2e4.");
                bsiDatabaseManager.saveMessageStatus(toApplicationMessage.getMessageId(), BiMessageStatus.Success, "");
            }
            catch (Throwable e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
                Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "Business logic \ucc98\ub9ac\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4", e.toString());
                log.info((Object)"\uba54\uc2dc\uc9c0 \uc0c1\ud0dc\ub97c Fail\ub85c \ubcc0\uacbd\ud569\ub2c8\ub2e4.");
                bsiDatabaseManager.saveMessageStatus(toApplicationMessage.getMessageId(), BiMessageStatus.Fail, e.getMessage());
            }
        }
        finally {
            ApplicationResultMessage resultMessage = new ApplicationResultMessage();
            try {
                if (bsiUserProcesserResult == null) {
                    resultMessage.setUid(toApplicationMessage.getUid());
                    resultMessage.setNullMessage(true);
                    resultMessage.setBlock(toApplicationMessage.getBlock());
                    resultMessage.setRefToMessageId(toApplicationMessage.getMessageId());
                } else {
                    resultMessage.setUid(toApplicationMessage.getUid());
                    resultMessage.setNullMessage(false);
                    resultMessage.setBlock(toApplicationMessage.getBlock());
                    resultMessage.setCpaId(toApplicationMessage.getCpaId());
                    resultMessage.setFrom(toApplicationMessage.getTo());
                    resultMessage.setTo(toApplicationMessage.getFrom());
                    resultMessage.setRefToMessageId(toApplicationMessage.getMessageId());
                    resultMessage.setConversationId(toApplicationMessage.getConversationId());
                    resultMessage.setService(bsiUserProcesserResult.getService());
                    resultMessage.setAction(bsiUserProcesserResult.getAction());
                    resultMessage.setPayloadCount(bsiUserProcesserResult.getPayloadCount());
                    resultMessage.setPayloads(bsiUserProcesserResult.getPayloads());
                }
                log.info((Object)"ApplicationResult Queue\ub85c \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4.");
                Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "ApplicationResult Queue\ub85c \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud569\ub2c8\ub2e4", "");
                QueueHelper queueHelper = new QueueHelper(queueConnectionFactory, applicationResultQueue);
                queueHelper.sendMessage(resultMessage, new ApplicationResultMessageConverter());
            }
            catch (RuntimeException e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
                Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "ApplicationResult Queue\ub85c \uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4", e.getMessage());
                bsiDatabaseManager.saveMessageStatus(toApplicationMessage.getMessageId(), BiMessageStatus.Fail, e.getMessage());
            }
            Tracker.tracking(toApplicationMessage.getMessageId(), new Date(), "Business logic\uc744 \uc885\ub8cc \ud569\ub2c8\ub2e4", "");
        }
    }

    public abstract BiUserProcesserResult userProcesser(ToApplicationMessage var1) throws BiUserProcesserException;
}

