/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationKey;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.UnionCombiner;
import org.apache.commons.configuration.tree.ViewNode;

public class CombinedConfiguration
extends HierarchicalConfiguration
implements ConfigurationListener,
Cloneable {
    public static final int EVENT_COMBINED_INVALIDATE = 40;
    private static final long serialVersionUID = 8338574525528692307L;
    private static final DefaultExpressionEngine AT_ENGINE = new DefaultExpressionEngine();
    private static final NodeCombiner DEFAULT_COMBINER = new UnionCombiner();
    private NodeCombiner nodeCombiner;
    private ConfigurationNode combinedRoot;
    private List configurations;
    private Map namedConfigurations;

    public CombinedConfiguration(NodeCombiner comb) {
        this.setNodeCombiner(comb != null ? comb : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration() {
        this(null);
    }

    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidate();
    }

    public void addConfiguration(AbstractConfiguration config, String name, String at) {
        if (config == null) {
            throw new IllegalArgumentException("Added configuration must not be null!");
        }
        if (name != null && this.namedConfigurations.containsKey(name)) {
            throw new ConfigurationRuntimeException("A configuration with the name '" + name + "' already exists in this combined configuration!");
        }
        ConfigData cd = new ConfigData(config, name, at);
        this.configurations.add(cd);
        if (name != null) {
            this.namedConfigurations.put(name, config);
        }
        config.addConfigurationListener(this);
        this.invalidate();
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        this.addConfiguration(config, name, null);
    }

    public void addConfiguration(AbstractConfiguration config) {
        this.addConfiguration(config, null, null);
    }

    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    public Configuration getConfiguration(int index) {
        ConfigData cd = (ConfigData)this.configurations.get(index);
        return cd.getConfiguration();
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)this.namedConfigurations.get(name);
    }

    public boolean removeConfiguration(Configuration config) {
        int index = 0;
        while (index < this.getNumberOfConfigurations()) {
            if (((ConfigData)this.configurations.get(index)).getConfiguration() == config) {
                this.removeConfigurationAt(index);
                return true;
            }
            ++index;
        }
        return false;
    }

    public Configuration removeConfigurationAt(int index) {
        ConfigData cd = (ConfigData)this.configurations.remove(index);
        if (cd.getName() != null) {
            this.namedConfigurations.remove(cd.getName());
        }
        cd.getConfiguration().removeConfigurationListener(this);
        this.invalidate();
        return cd.getConfiguration();
    }

    public Configuration removeConfiguration(String name) {
        Configuration conf = this.getConfiguration(name);
        if (conf != null) {
            this.removeConfiguration(conf);
        }
        return conf;
    }

    public Set getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    public void invalidate() {
        NodeCombiner nodeCombiner = this.getNodeCombiner();
        synchronized (nodeCombiner) {
            this.combinedRoot = null;
        }
        this.fireEvent(40, null, null, false);
    }

    public void configurationChanged(ConfigurationEvent event) {
        this.invalidate();
    }

    public ConfigurationNode getRootNode() {
        NodeCombiner nodeCombiner = this.getNodeCombiner();
        synchronized (nodeCombiner) {
            if (this.combinedRoot == null) {
                this.combinedRoot = this.constructCombinedNode();
            }
            ConfigurationNode configurationNode = this.combinedRoot;
            return configurationNode;
        }
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        this.configurations = new ArrayList();
        this.namedConfigurations = new HashMap();
        this.fireEvent(4, null, null, false);
        this.invalidate();
    }

    public Object clone() {
        CombinedConfiguration copy = (CombinedConfiguration)super.clone();
        copy.clear();
        Iterator it = this.configurations.iterator();
        while (it.hasNext()) {
            ConfigData cd = (ConfigData)it.next();
            copy.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration(cd.getConfiguration()), cd.getName(), cd.getAt());
        }
        copy.setRootNode(new DefaultConfigurationNode());
        return copy;
    }

    private ConfigurationNode constructCombinedNode() {
        if (this.getNumberOfConfigurations() < 1) {
            return new ViewNode();
        }
        Iterator it = this.configurations.iterator();
        ConfigurationNode node = ((ConfigData)it.next()).getTransformedRoot();
        while (it.hasNext()) {
            node = this.getNodeCombiner().combine(node, ((ConfigData)it.next()).getTransformedRoot());
        }
        return node;
    }

    static class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private Collection atPath;
        private String at;

        public ConfigData(AbstractConfiguration config, String n, String at) {
            this.configuration = config;
            this.name = n;
            this.atPath = this.parseAt(at);
            this.at = at;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }

        public ConfigurationNode getTransformedRoot() {
            ViewNode result;
            ViewNode atParent = result = new ViewNode();
            if (this.atPath != null) {
                Iterator it = this.atPath.iterator();
                while (it.hasNext()) {
                    ViewNode node = new ViewNode();
                    node.setName((String)it.next());
                    atParent.addChild(node);
                    atParent = node;
                }
            }
            HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical(this.getConfiguration());
            atParent.appendChildren(hc.getRootNode());
            atParent.appendAttributes(hc.getRootNode());
            return result;
        }

        private Collection parseAt(String at) {
            if (at == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            DefaultConfigurationKey.KeyIterator it = new DefaultConfigurationKey(AT_ENGINE, at).iterator();
            while (it.hasNext()) {
                result.add(it.nextKey());
            }
            return result;
        }
    }
}

