/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.util.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileIoUtil {
    public static byte[] readDataFromFile(String _filePath) throws IOException {
        if (!FileIoUtil.hasFile(_filePath)) {
            throw new FileNotFoundException("\ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. File name: " + _filePath);
        }
        File file = new File(_filePath);
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = fileInputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, count);
        }
        byte[] result = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        fileInputStream.close();
        return result;
    }

    public static void saveDataToFile(String _directoryPath, String _fileName, byte[] _fileData) throws IOException {
        _directoryPath = FileIoUtil.fileSeparatorAddOrNone(_directoryPath);
        FileIoUtil.directoryCreateOrNone(_directoryPath);
        try {
            File f = new File(String.valueOf(_directoryPath) + _fileName);
            f.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            fileOutputStream.write(_fileData);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException e) {
            throw new IOException("\ud30c\uc77c\uc5d0 \uc4f8\uc218 \uc5c6\uc2b5\ub2c8\ub2e4. File name: " + _directoryPath + _fileName);
        }
    }

    public static boolean hasFile(String _filePath) {
        File file = new File(_filePath);
        return file.exists();
    }

    public static boolean hasDirectory(String _directoryPath) {
        File directory = new File(_directoryPath);
        return directory.exists();
    }

    public static boolean directoryCreateOrNone(String _directoryPath) {
        if (!FileIoUtil.hasDirectory(_directoryPath)) {
            return new File(_directoryPath).mkdirs();
        }
        return true;
    }

    public static String fileSeparatorAddOrNone(String _directoryPath) {
        if (!_directoryPath.endsWith("/") && !_directoryPath.endsWith("\\")) {
            _directoryPath = String.valueOf(_directoryPath) + File.separator;
        }
        return _directoryPath;
    }

    public static boolean isAbsolutePath(String _directoryPath) {
        File file = new File(_directoryPath);
        return file.isAbsolute();
    }

    public static boolean delete(String _filePath) {
        File file = new File(_filePath);
        return file.delete();
    }
}

