/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMDSASignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMHMACSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMRSASignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMSignatureMethod
extends DOMStructure
implements SignatureMethod {
    private String algorithm;
    private SignatureMethodParameterSpec params;

    protected DOMSignatureMethod(String algorithm, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm cannot be null");
        }
        if (params != null && !(params instanceof SignatureMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type SignatureMethodParameterSpec");
        }
        this.checkParams((SignatureMethodParameterSpec)params);
        this.algorithm = algorithm;
        this.params = (SignatureMethodParameterSpec)params;
    }

    protected DOMSignatureMethod(Element smElem) throws MarshalException {
        this.algorithm = DOMUtils.getAttributeValue(smElem, "Algorithm");
        Element paramsElem = DOMUtils.getFirstChildElement(smElem);
        if (paramsElem != null) {
            this.params = this.unmarshalParams(paramsElem);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new MarshalException(iape);
        }
    }

    static SignatureMethod unmarshal(Element smElem) throws MarshalException {
        String alg = DOMUtils.getAttributeValue(smElem, "Algorithm");
        if (alg.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            return new DOMHMACSignatureMethod(smElem);
        }
        if (alg.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return new DOMRSASignatureMethod(smElem);
        }
        if (alg.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return new DOMDSASignatureMethod(smElem);
        }
        throw new MarshalException("unsupported signature algorithm: " + alg);
    }

    protected abstract void checkParams(SignatureMethodParameterSpec var1) throws InvalidAlgorithmParameterException;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    protected abstract SignatureMethodParameterSpec unmarshalParams(Element var1) throws MarshalException;

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element smElem = DOMUtils.createElement(ownerDoc, "SignatureMethod", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttribute(smElem, "Algorithm", this.algorithm);
        if (this.params != null) {
            this.marshalParams(smElem, dsPrefix);
        }
        parent.appendChild(smElem);
    }

    public abstract boolean verify(Key var1, DOMSignedInfo var2, byte[] var3, XMLValidateContext var4) throws InvalidKeyException, SignatureException, XMLSignatureException;

    public abstract byte[] sign(Key var1, DOMSignedInfo var2, XMLSignContext var3) throws InvalidKeyException, XMLSignatureException;

    protected abstract void marshalParams(Element var1, String var2) throws MarshalException;

    protected abstract boolean paramsEqual(AlgorithmParameterSpec var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureMethod)) {
            return false;
        }
        SignatureMethod osm = (SignatureMethod)o;
        return this.algorithm.equals(osm.getAlgorithm()) && this.paramsEqual(osm.getParameterSpec());
    }

    public int hashCode() {
        return 57;
    }
}

