/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.w3c.dom.Element;

public abstract class DOMSHADigestMethod
extends DOMDigestMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");

    protected DOMSHADigestMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super(params);
    }

    protected DOMSHADigestMethod(Element dmElem) throws MarshalException {
        super(dmElem);
    }

    protected void checkParams(DigestMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for the " + this.getName() + " DigestMethod algorithm");
        }
    }

    protected DigestMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getName() + " DigestMethod algorithm");
    }

    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getName() + " DigestMethod algorithm");
    }

    abstract String getName();

    static final DOMSHADigestMethod SHA1(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        return new DOMSHA1DigestMethod(params);
    }

    static final DOMSHADigestMethod SHA1(Element dmElem) throws MarshalException {
        return new DOMSHA1DigestMethod(dmElem);
    }

    static final DOMSHADigestMethod SHA256(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        return new DOMSHA256DigestMethod(params);
    }

    static final DOMSHADigestMethod SHA256(Element dmElem) throws MarshalException {
        return new DOMSHA256DigestMethod(dmElem);
    }

    static final DOMSHADigestMethod SHA512(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        return new DOMSHA512DigestMethod(params);
    }

    static final DOMSHADigestMethod SHA512(Element dmElem) throws MarshalException {
        return new DOMSHA512DigestMethod(dmElem);
    }

    private static final class DOMSHA1DigestMethod
    extends DOMSHADigestMethod {
        DOMSHA1DigestMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            super(params);
        }

        DOMSHA1DigestMethod(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }

        String getMessageDigestAlgorithm() {
            return "SHA";
        }

        String getName() {
            return "SHA1";
        }
    }

    private static final class DOMSHA256DigestMethod
    extends DOMSHADigestMethod {
        DOMSHA256DigestMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            super(params);
        }

        DOMSHA256DigestMethod(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }

        String getMessageDigestAlgorithm() {
            return "SHA-256";
        }

        String getName() {
            return "SHA256";
        }
    }

    private static final class DOMSHA512DigestMethod
    extends DOMSHADigestMethod {
        DOMSHA512DigestMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            super(params);
        }

        DOMSHA512DigestMethod(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }

        String getMessageDigestAlgorithm() {
            return "SHA-512";
        }

        String getName() {
            return "SHA512";
        }
    }
}

