/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMSHADigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMDigestMethod
extends DOMStructure
implements DigestMethod {
    private DigestMethodParameterSpec params;

    protected DOMDigestMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof DigestMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type DigestMethodParameterSpec");
        }
        this.checkParams((DigestMethodParameterSpec)params);
        this.params = (DigestMethodParameterSpec)params;
    }

    protected DOMDigestMethod(Element dmElem) throws MarshalException {
        Element paramsElem = DOMUtils.getFirstChildElement(dmElem);
        if (paramsElem != null) {
            this.params = this.unmarshalParams(paramsElem);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new MarshalException(iape);
        }
    }

    static DigestMethod unmarshal(Element dmElem) throws MarshalException {
        String alg = DOMUtils.getAttributeValue(dmElem, "Algorithm");
        if (alg.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            return DOMSHADigestMethod.SHA1(dmElem);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
            return DOMSHADigestMethod.SHA256(dmElem);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            return DOMSHADigestMethod.SHA512(dmElem);
        }
        throw new MarshalException("unsupported digest algorithm: " + alg);
    }

    protected abstract void checkParams(DigestMethodParameterSpec var1) throws InvalidAlgorithmParameterException;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    protected abstract DigestMethodParameterSpec unmarshalParams(Element var1) throws MarshalException;

    public void marshal(Node parent, String prefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element dmElem = DOMUtils.createElement(ownerDoc, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", prefix);
        DOMUtils.setAttribute(dmElem, "Algorithm", this.getAlgorithm());
        if (this.params != null) {
            this.marshalParams(dmElem, prefix);
        }
        parent.appendChild(dmElem);
    }

    public boolean equals(Object o) {
        boolean paramsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof DigestMethod)) {
            return false;
        }
        DigestMethod odm = (DigestMethod)o;
        boolean bl = this.params == null ? odm.getParameterSpec() == null : (paramsEqual = this.params.equals(odm.getParameterSpec()));
        return this.getAlgorithm().equals(odm.getAlgorithm()) && paramsEqual;
    }

    public int hashCode() {
        return 51;
    }

    protected abstract void marshalParams(Element var1, String var2) throws MarshalException;

    abstract String getMessageDigestAlgorithm();
}

