/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.exceptions.XMLSecurityRuntimeException;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, Transform _transformObject) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(_transformObject.getElement().getOwnerDocument());
            Element xpathElement = XMLUtils.selectDsNode(_transformObject.getElement().getFirstChild(), "XPath", 0);
            if (xpathElement == null) {
                Object[] exArgs = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            Node xpathnode = xpathElement.getChildNodes().item(0);
            String str = CachedXPathFuncHereAPI.getStrFromNode(xpathnode);
            input.setNeedsToBeExpanded(this.needsCircunvent(str));
            if (xpathnode == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            input.addNodeFilter(new XPathNodeFilter(xpathElement, xpathnode, str));
            input.setNodeSet(true);
            return input;
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private boolean needsCircunvent(String str) {
        return str.indexOf("namespace") != -1 || str.indexOf("name()") != -1;
    }

    static class XPathNodeFilter
    implements NodeFilter {
        PrefixResolverDefault prefixResolver;
        CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
        Node xpathnode;
        String str;

        XPathNodeFilter(Element xpathElement, Node xpathnode, String str) {
            this.xpathnode = xpathnode;
            this.str = str;
            this.prefixResolver = new PrefixResolverDefault(xpathElement);
        }

        public int isNodeInclude(Node currentNode) {
            try {
                XObject includeInResult = this.xPathFuncHereAPI.eval(currentNode, this.xpathnode, this.str, this.prefixResolver);
                if (includeInResult.bool()) {
                    return 1;
                }
                return 0;
            }
            catch (TransformerException e) {
                Object[] eArgs = new Object[]{currentNode};
                throw new XMLSecurityRuntimeException("signature.Transform.node", eArgs, e);
            }
            catch (Exception e) {
                Object[] eArgs = new Object[]{currentNode, new Short(currentNode.getNodeType())};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", eArgs, e);
            }
        }

        public int isNodeIncludeDO(Node n, int level) {
            return this.isNodeInclude(n);
        }
    }
}

