/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.setup;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.kldp.ebmsh.setup.EbmsSetupException;
import org.kldp.ebmsh.setup.EbmsSetupQueryLoader;
import org.kldp.ebmsh.setup.EbmsSetupUtils;
import org.kldp.util.io.FileIoUtil;
import org.kldp.util.j2ee.resource.DataSourceServiceLocator;

public class EbmsSetupManager {
    public void createCpaDirectory(String cpaSetupRealPath) throws EbmsSetupException {
        block4: {
            try {
                if (!FileIoUtil.hasDirectory((String)cpaSetupRealPath)) {
                    if (!FileIoUtil.directoryCreateOrNone((String)cpaSetupRealPath)) {
                        throw new EbmsSetupException("\ub514\ub809\ud1a0\ub9ac\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    break block4;
                }
                throw new EbmsSetupException("\uc774\ubbf8 \uc874\uc7ac\ud558\ub294 \ub514\ub809\ud1a0\ub9ac \uc785\ub2c8\ub2e4.");
            }
            catch (Throwable t) {
                throw new EbmsSetupException(t);
            }
        }
    }

    public void createMessageDirectory(String messageSetupRealPath) throws EbmsSetupException {
        block4: {
            try {
                if (!FileIoUtil.hasDirectory((String)messageSetupRealPath)) {
                    if (!FileIoUtil.directoryCreateOrNone((String)messageSetupRealPath)) {
                        throw new EbmsSetupException("\ub514\ub809\ud1a0\ub9ac\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    break block4;
                }
                throw new EbmsSetupException("\uc774\ubbf8 \uc874\uc7ac\ud558\ub294 \ub514\ub809\ud1a0\ub9ac \uc785\ub2c8\ub2e4.");
            }
            catch (Throwable t) {
                throw new EbmsSetupException(t);
            }
        }
    }

    public void createDatabase(String bizboxSetupSqlPath, String dataSourceName, String databaseType, String bizboxDatabaseHeaderName) throws EbmsSetupException {
        String createIncomingMessageTable = "";
        String createOutgoingMessageTable = "";
        String createMessageStoreTable = "";
        String createMessageStatusTable = "";
        String createAckMessageTable = "";
        String createDuplicateMessageTable = "";
        String createMessageIdAndDocumentIdTable = "";
        String createTrackerTable = "";
        String createBsiMessageStatusTable = "";
        String createAdminTable = "";
        String createDocumentIdInfoTable = "";
        String createIncomingMessageIndex = "";
        String createOutgoingMessageIndex = "";
        String createDocumentIdIndex = "";
        String createAdminInsert = "";
        DataSource dataSource = null;
        try {
            dataSource = DataSourceServiceLocator.getInstance().getDataSource(dataSourceName);
        }
        catch (NamingException e) {
            throw new EbmsSetupException("DataSource\ub97c \ub8e9\uc5c5\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ( datasource -> " + dataSourceName + " )");
        }
        catch (Throwable e) {
            throw new EbmsSetupException(e);
        }
        try {
            EbmsSetupQueryLoader queryLoader = new EbmsSetupQueryLoader(bizboxSetupSqlPath);
            if (databaseType.equals("mysql")) {
                createIncomingMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlIncomingMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createOutgoingMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlOutgoingMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createMessageStoreTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlMessageStoreTableCreateSql(), bizboxDatabaseHeaderName);
                createMessageStatusTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlMessageStatusTableCreateSql(), bizboxDatabaseHeaderName);
                createAckMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlAckMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createDuplicateMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlDuplicateMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createMessageIdAndDocumentIdTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlMessageIdAndDocumentIdTableCreateSql(), bizboxDatabaseHeaderName);
                createTrackerTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlTrackerTableCreateSql(), bizboxDatabaseHeaderName);
                createBsiMessageStatusTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlBsiMessageStatusTableCreateSql(), bizboxDatabaseHeaderName);
                createAdminTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlAdminTableCreateSql(), bizboxDatabaseHeaderName);
                createDocumentIdInfoTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlDocumentIdInfoTableCreateSql(), bizboxDatabaseHeaderName);
                createIncomingMessageIndex = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlIncomingMessageIndexCreateSql(), bizboxDatabaseHeaderName);
                createOutgoingMessageIndex = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlOutgoingMessageIndexCreateSql(), bizboxDatabaseHeaderName);
                createDocumentIdIndex = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlDocumentIdIndexCreateSql(), bizboxDatabaseHeaderName);
                createAdminInsert = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getMysqlAdminInsertSql(), bizboxDatabaseHeaderName);
            } else if (databaseType.equals("oracle")) {
                createIncomingMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleIncomingMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createOutgoingMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleOutgoingMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createMessageStoreTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleMessageStoreTableCreateSql(), bizboxDatabaseHeaderName);
                createMessageStatusTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleMessageStatusTableCreateSql(), bizboxDatabaseHeaderName);
                createAckMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleAckMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createDuplicateMessageTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleDuplicateMessageTableCreateSql(), bizboxDatabaseHeaderName);
                createMessageIdAndDocumentIdTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleMessageIdAndDocumentIdTableCreateSql(), bizboxDatabaseHeaderName);
                createTrackerTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleTrackerTableCreateSql(), bizboxDatabaseHeaderName);
                createBsiMessageStatusTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleBsiMessageStatusTableCreateSql(), bizboxDatabaseHeaderName);
                createAdminTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleAdminTableCreateSql(), bizboxDatabaseHeaderName);
                createDocumentIdInfoTable = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleDocumentIdInfoTableCreateSql(), bizboxDatabaseHeaderName);
                createIncomingMessageIndex = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleIncomingMessageIndexCreateSql(), bizboxDatabaseHeaderName);
                createOutgoingMessageIndex = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleOutgoingMessageIndexCreateSql(), bizboxDatabaseHeaderName);
                createDocumentIdIndex = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleDocumentIdIndexCreateSql(), bizboxDatabaseHeaderName);
                createAdminInsert = EbmsSetupUtils.replaceToBizboxDatabaseHeaderName(queryLoader.getOracleAdminInsertSql(), bizboxDatabaseHeaderName);
            } else {
                throw new EbmsSetupException("Bizbox\uac00 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 Database \uc785\ub2c8\ub2e4. ( database type -> " + databaseType + " )");
            }
            Connection connection = null;
            Statement stmt = null;
            try {
                try {
                    connection = dataSource.getConnection();
                    stmt = connection.createStatement();
                    System.out.println(createIncomingMessageTable);
                    stmt.executeUpdate(createIncomingMessageTable);
                    System.out.println(createOutgoingMessageTable);
                    stmt.executeUpdate(createOutgoingMessageTable);
                    System.out.println(createMessageStoreTable);
                    stmt.executeUpdate(createMessageStoreTable);
                    System.out.println(createMessageStatusTable);
                    stmt.executeUpdate(createMessageStatusTable);
                    System.out.println(createAckMessageTable);
                    stmt.executeUpdate(createAckMessageTable);
                    System.out.println(createDuplicateMessageTable);
                    stmt.executeUpdate(createDuplicateMessageTable);
                    System.out.println(createMessageIdAndDocumentIdTable);
                    stmt.executeUpdate(createMessageIdAndDocumentIdTable);
                    System.out.println(createTrackerTable);
                    stmt.executeUpdate(createTrackerTable);
                    System.out.println(createBsiMessageStatusTable);
                    stmt.executeUpdate(createBsiMessageStatusTable);
                    System.out.println(createAdminTable);
                    stmt.executeUpdate(createAdminTable);
                    System.out.println(createDocumentIdInfoTable);
                    stmt.executeUpdate(createDocumentIdInfoTable);
                    System.out.println(createIncomingMessageIndex);
                    stmt.executeUpdate(createIncomingMessageIndex);
                    System.out.println(createOutgoingMessageIndex);
                    stmt.executeUpdate(createOutgoingMessageIndex);
                    System.out.println(createDocumentIdIndex);
                    stmt.executeUpdate(createDocumentIdIndex);
                    System.out.println(createAdminInsert);
                    stmt.executeUpdate(createAdminInsert);
                }
                catch (SQLException e) {
                    throw new EbmsSetupException(e);
                }
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    DbUtils.closeQuietly(stmt);
                }
                if (connection != null) {
                    DbUtils.closeQuietly((Connection)connection);
                }
                throw throwable;
            }
            if (stmt != null) {
                DbUtils.closeQuietly((Statement)stmt);
            }
            if (connection != null) {
                DbUtils.closeQuietly((Connection)connection);
            }
        }
        catch (IOException e) {
            throw new EbmsSetupException("Bizbox setup\uc5d0 \uad00\ud55c \ucffc\ub9ac \ud30c\uc77c\uc744 \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ( query file -> " + bizboxSetupSqlPath + " )");
        }
        catch (EbmsSetupException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EbmsSetupException(e);
        }
    }
}

