/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.moniter.failHandler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kldp.ebmsh.application.NonBlockingApplicationProcesser;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.transport.EbxmlMessageSender;
import org.kldp.ebmsh.message.util.Serializer;
import org.kldp.ebmsh.moniter.failHandler.BiFailMessageInfo;
import org.kldp.ebmsh.moniter.failHandler.BiFailMessageProcessResult;
import org.kldp.ebmsh.moniter.failHandler.EngineFailMessageInfo;
import org.kldp.ebmsh.moniter.failHandler.EngineFailMessageProcessResult;
import org.kldp.ebmsh.moniter.persistant.BsiMessageStatus;
import org.kldp.ebmsh.moniter.persistant.EbmsMoniterManager;
import org.kldp.ebmsh.moniter.persistant.InComingMessage;
import org.kldp.ebmsh.moniter.persistant.MoniterPersistantException;
import org.kldp.util.io.FileIoUtil;
import org.kldp.util.log.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailMessageManager {
    public List<BiFailMessageInfo> getBusinessLogicFailMessage() throws MoniterPersistantException {
        EbmsMoniterManager moniterManager = new EbmsMoniterManager();
        ArrayList<BiFailMessageInfo> biFailMessageInfoList = new ArrayList<BiFailMessageInfo>();
        List failBsiMessages = moniterManager.searchFailBsiMessages();
        int i = 0;
        while (i < failBsiMessages.size()) {
            BsiMessageStatus bsiMessageStatus = (BsiMessageStatus)failBsiMessages.get(i);
            InComingMessage incomingMessage = moniterManager.getInComingMessage(bsiMessageStatus.getMessageId());
            BiFailMessageInfo biFailMessageInfo = new BiFailMessageInfo();
            biFailMessageInfo.setMessagePath(incomingMessage.getMSGFilePath());
            biFailMessageInfo.setMessageId(bsiMessageStatus.getMessageId());
            biFailMessageInfo.setStatus(bsiMessageStatus.getStatus());
            biFailMessageInfoList.add(biFailMessageInfo);
            ++i;
        }
        return biFailMessageInfoList;
    }

    public List<EngineFailMessageInfo> getEbxmlEngineFaultMessage() {
        ArrayList<EngineFailMessageInfo> faultMessageInfoList = new ArrayList<EngineFailMessageInfo>();
        String failMessagePath = String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"fail");
        File failMessageDirectory = new File(failMessagePath);
        File[] failMessageArray = failMessageDirectory.listFiles();
        int i = 0;
        while (i < failMessageArray.length) {
            File failMessage = failMessageArray[i];
            String fileName = failMessage.getName();
            Date fileMakeTime = new Date(failMessage.lastModified());
            EngineFailMessageInfo faultMessageInfo = new EngineFailMessageInfo();
            faultMessageInfo.setFileName(fileName);
            faultMessageInfo.setFileMakeTime(fileMakeTime);
            faultMessageInfoList.add(faultMessageInfo);
            ++i;
        }
        return faultMessageInfoList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BiFailMessageProcessResult reProcessBiFailMessage(String messageId, String messagePath) {
        String failMessagePath = String.valueOf(EbmsConstants.messagePath) + messagePath;
        BiFailMessageProcessResult biFailMessageProcessResult = new BiFailMessageProcessResult();
        biFailMessageProcessResult.setMessageId(messageId);
        try {
            if (!FileIoUtil.hasFile((String)failMessagePath)) {
                biFailMessageProcessResult.setSuccess(false);
                biFailMessageProcessResult.setMessage("\ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return biFailMessageProcessResult;
            }
            FileInputStream is = null;
            EbxmlMessage ebxmlMessage = null;
            try {
                try {
                    is = new FileInputStream(failMessagePath);
                    ebxmlMessage = Serializer.deserialize((InputStream)is);
                }
                catch (Throwable e) {
                    biFailMessageProcessResult.setSuccess(false);
                    biFailMessageProcessResult.setMessage("\uba54\uc2dc\uc9c0\ub97c \uac1d\uccb4\ud654 \ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    biFailMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)e));
                    BiFailMessageProcessResult biFailMessageProcessResult2 = biFailMessageProcessResult;
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    return biFailMessageProcessResult2;
                }
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            try {
                new NonBlockingApplicationProcesser().process(ebxmlMessage);
            }
            catch (Throwable e) {
                biFailMessageProcessResult.setSuccess(false);
                biFailMessageProcessResult.setMessage("\uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
                biFailMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)e));
                return biFailMessageProcessResult;
            }
            biFailMessageProcessResult.setSuccess(true);
            biFailMessageProcessResult.setMessage("\uc7ac\ucc98\ub9ac \uc694\uccad \uc131\uacf5");
            return biFailMessageProcessResult;
        }
        catch (Throwable t) {
            biFailMessageProcessResult.setSuccess(false);
            biFailMessageProcessResult.setMessage("\uc54c\uc218 \uc5c6\ub294 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            biFailMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)t));
            return biFailMessageProcessResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EngineFailMessageProcessResult reProcessFailMessage(String failMessageFileName, String url) {
        EbxmlMessage ebxmlMessage;
        byte[] ebxmlMessageByte;
        EngineFailMessageProcessResult failMessageProcessResult;
        String failMessagePath;
        String failMessageDirectory;
        block39: {
            FileInputStream is;
            failMessageDirectory = String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"fail");
            failMessagePath = String.valueOf(failMessageDirectory) + failMessageFileName;
            failMessageProcessResult = new EngineFailMessageProcessResult();
            failMessageProcessResult.setFileName(failMessageFileName);
            ebxmlMessageByte = null;
            try {
                if (!FileIoUtil.hasFile((String)failMessagePath)) {
                    failMessageProcessResult.setSuccess(false);
                    failMessageProcessResult.setMessage("\ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    EngineFailMessageProcessResult engineFailMessageProcessResult = failMessageProcessResult;
                    return engineFailMessageProcessResult;
                }
                try {
                    ebxmlMessageByte = FileIoUtil.readDataFromFile((String)failMessagePath);
                }
                catch (Throwable e) {
                    failMessageProcessResult.setSuccess(false);
                    failMessageProcessResult.setMessage("\ud30c\uc77c\uc744 \uc77d\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)e));
                    EngineFailMessageProcessResult engineFailMessageProcessResult = failMessageProcessResult;
                    if (failMessageProcessResult.isSuccess()) return engineFailMessageProcessResult;
                    if (FileIoUtil.hasFile((String)(String.valueOf(failMessageDirectory) + failMessageFileName))) return engineFailMessageProcessResult;
                    try {
                        FileIoUtil.saveDataToFile((String)failMessageDirectory, (String)failMessageFileName, (byte[])ebxmlMessageByte);
                        return engineFailMessageProcessResult;
                    }
                    catch (Throwable t) {
                        failMessageProcessResult.setSuccess(false);
                        failMessageProcessResult.setMessage("Ebxml message\ub97c \ud30c\uc77c\uc5d0 \uae30\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)t));
                        return failMessageProcessResult;
                    }
                }
                is = null;
                ebxmlMessage = null;
                try {
                    is = new FileInputStream(failMessagePath);
                    ebxmlMessage = Serializer.deserialize((InputStream)is);
                }
                catch (Throwable e) {
                    failMessageProcessResult.setSuccess(false);
                    failMessageProcessResult.setMessage("\uba54\uc2dc\uc9c0\ub97c \uac1d\uccb4\ud654 \ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)e));
                    EngineFailMessageProcessResult engineFailMessageProcessResult = failMessageProcessResult;
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    if (failMessageProcessResult.isSuccess()) return engineFailMessageProcessResult;
                    if (FileIoUtil.hasFile((String)(String.valueOf(failMessageDirectory) + failMessageFileName))) return engineFailMessageProcessResult;
                    try {
                        FileIoUtil.saveDataToFile((String)failMessageDirectory, (String)failMessageFileName, (byte[])ebxmlMessageByte);
                        return engineFailMessageProcessResult;
                    }
                    catch (Throwable t) {
                        failMessageProcessResult.setSuccess(false);
                        failMessageProcessResult.setMessage("Ebxml message\ub97c \ud30c\uc77c\uc5d0 \uae30\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)t));
                        return failMessageProcessResult;
                    }
                }
            }
            catch (Throwable t) {
                failMessageProcessResult.setSuccess(false);
                failMessageProcessResult.setMessage("\uc54c\uc218 \uc5c6\ub294 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)t));
                EngineFailMessageProcessResult engineFailMessageProcessResult = failMessageProcessResult;
                return engineFailMessageProcessResult;
            }
            finally {
                if (is == null) break block39;
            }
            ((InputStream)is).close();
        }
        FileIoUtil.delete((String)failMessagePath);
        EbxmlMessage resultEbxmlMessage = null;
        try {
            EbxmlMessageSender sender = new EbxmlMessageSender();
            resultEbxmlMessage = sender.sendMessageForFaultHandler(ebxmlMessage, url);
        }
        catch (Throwable e) {
            failMessageProcessResult.setSuccess(false);
            failMessageProcessResult.setMessage("\uba54\uc2dc\uc9c0\ub97c \uc804\uc1a1\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
            failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)e));
            EngineFailMessageProcessResult engineFailMessageProcessResult = failMessageProcessResult;
            if (failMessageProcessResult.isSuccess()) return engineFailMessageProcessResult;
            if (FileIoUtil.hasFile((String)(String.valueOf(failMessageDirectory) + failMessageFileName))) return engineFailMessageProcessResult;
            try {
                FileIoUtil.saveDataToFile((String)failMessageDirectory, (String)failMessageFileName, (byte[])ebxmlMessageByte);
                return engineFailMessageProcessResult;
            }
            catch (Throwable t) {
                failMessageProcessResult.setSuccess(false);
                failMessageProcessResult.setMessage("Ebxml message\ub97c \ud30c\uc77c\uc5d0 \uae30\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)t));
                return failMessageProcessResult;
            }
        }
        if (resultEbxmlMessage == null) {
            failMessageProcessResult.setSuccess(false);
            failMessageProcessResult.setMessage("\uc751\ub2f5 \uba54\uc2dc\uc9c0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return failMessageProcessResult;
        }
        failMessageProcessResult.setSuccess(true);
        failMessageProcessResult.setMessage("\uc7ac\ucc98\ub9ac \uc694\uccad \uc131\uacf5");
        return failMessageProcessResult;
        finally {
            if (!failMessageProcessResult.isSuccess() && !FileIoUtil.hasFile((String)(String.valueOf(failMessageDirectory) + failMessageFileName))) {
                try {
                    FileIoUtil.saveDataToFile((String)failMessageDirectory, (String)failMessageFileName, (byte[])ebxmlMessageByte);
                }
                catch (Throwable t) {
                    failMessageProcessResult.setSuccess(false);
                    failMessageProcessResult.setMessage("Ebxml message\ub97c \ud30c\uc77c\uc5d0 \uae30\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    failMessageProcessResult.setDetailMessage(LogUtil.stackTraceToString((Throwable)t));
                    return failMessageProcessResult;
                }
            }
        }
    }
}

